/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

@Path(value="/swagger")
public class SwaggerSpecResource {
    @Context
    HttpHeaders httpHeaders;

    @Path(value="/private")
    @GET
    @Consumes(value={"*/*", "application/json", "text/yaml"})
    @Produces(value={"application/json", "text/yaml"})
    public String swaggerPrivate() {
        return this.swagger(SwaggerService.Visibility.PRIVATE);
    }

    @Path(value="/prototyping")
    @GET
    @Consumes(value={"*/*", "application/json", "text/yaml"})
    @Produces(value={"application/json", "text/yaml"})
    public String swaggerPrototyping() {
        return this.swagger(SwaggerService.Visibility.PRIVATE_WITH_PROTOTYPING);
    }

    @Path(value="/public")
    @GET
    @Consumes(value={"*/*", "application/json", "text/yaml"})
    @Produces(value={"application/json", "text/yaml"})
    public String swaggerPublic() {
        return this.swagger(SwaggerService.Visibility.PUBLIC);
    }

    private String swagger(SwaggerService.Visibility visibility) {
        SwaggerService.Format format = this.deriveFrom(this.httpHeaders);
        String spec = (String)this.getIsisSessionFactory().doInSession((Callable)new MyCallable(visibility, format));
        return spec;
    }

    private SwaggerService.Format deriveFrom(HttpHeaders httpHeaders) {
        List acceptableMediaTypes = httpHeaders.getAcceptableMediaTypes();
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            if (!acceptableMediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) continue;
            return SwaggerService.Format.JSON;
        }
        MediaType applYaml = new MediaType("application", "yaml");
        MediaType textYaml = new MediaType("text", "yaml");
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            if (!acceptableMediaType.isCompatible(applYaml) && !acceptableMediaType.isCompatible(textYaml)) continue;
            return SwaggerService.Format.YAML;
        }
        return SwaggerService.Format.JSON;
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    class MyCallable
    implements Callable<String> {
        private final SwaggerService.Visibility visibility;
        private final SwaggerService.Format format;
        @Inject
        SwaggerService swaggerService;

        public MyCallable(SwaggerService.Visibility visibility, SwaggerService.Format format) {
            this.visibility = visibility;
            this.format = format;
        }

        @Override
        public String call() throws Exception {
            this.getServicesInjector().injectServicesInto((Object)this);
            return this.swaggerService.generateSwaggerSpec(this.visibility, this.format);
        }

        ServicesInjector getServicesInjector() {
            return this.getPersistenceSession().getServicesInjector();
        }

        PersistenceSession getPersistenceSession() {
            return SwaggerSpecResource.this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
        }
    }
}

