/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.server.resources.JsonParserHelper;

public class ObjectActionArgHelper {
    private final RendererContext rendererContext;
    private final ObjectAdapter objectAdapter;
    private final ObjectAction action;

    public ObjectActionArgHelper(RendererContext rendererContext, ObjectAdapter objectAdapter, ObjectAction action) {
        this.rendererContext = rendererContext;
        this.objectAdapter = objectAdapter;
        this.action = action;
    }

    public List<ObjectAdapter> parseAndValidateArguments(JsonRepresentation arguments) {
        List<JsonRepresentation> argList = ObjectActionArgHelper.argListFor(this.action, arguments);
        ArrayList argAdapters = Lists.newArrayList();
        List parameters = this.action.getParameters();
        boolean valid = true;
        for (int i = 0; i < argList.size(); ++i) {
            JsonRepresentation argRepr = argList.get(i);
            ObjectSpecification paramSpec = ((ObjectActionParameter)parameters.get(i)).getSpecification();
            try {
                ObjectAdapter argAdapter = new JsonParserHelper(this.rendererContext, paramSpec).objectAdapterFor(argRepr);
                argAdapters.add(argAdapter);
                ObjectActionParameter parameter = (ObjectActionParameter)parameters.get(i);
                Object argPojo = argAdapter != null ? argAdapter.getObject() : null;
                String reasonNotValid = parameter.isValid(this.objectAdapter, argPojo, InteractionInitiatedBy.USER);
                if (reasonNotValid == null) continue;
                argRepr.mapPut("invalidReason", reasonNotValid);
                valid = false;
                continue;
            }
            catch (IllegalArgumentException e) {
                argAdapters.add(null);
                valid = false;
            }
        }
        ObjectAdapter[] argArray = argAdapters.toArray(new ObjectAdapter[0]);
        Consent consent = this.action.isArgumentSetValid(this.objectAdapter, argArray, InteractionInitiatedBy.USER);
        if (consent.isVetoed()) {
            arguments.mapPut("x-ro-invalidReason", consent.getReason());
            valid = false;
        }
        if (!valid) {
            throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.VALIDATION_FAILED, (JsonRepresentation)arguments, (String)"Validation failed, see body for details", (Object[])new Object[0]);
        }
        return argAdapters;
    }

    private static List<JsonRepresentation> argListFor(ObjectAction action, JsonRepresentation arguments) {
        ArrayList argList = Lists.newArrayList();
        for (Map.Entry arg : arguments.mapIterable()) {
            String argName = (String)arg.getKey();
            if (argName.startsWith("x-ro") || action.getParameterById(argName) != null) continue;
            String reason = String.format("Argument '%s' found but no such parameter", argName);
            arguments.mapPut("x-ro-invalidReason", reason);
            throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)arguments, (String)reason, (Object[])new Object[0]);
        }
        List parameters = action.getParameters();
        for (ObjectActionParameter param : parameters) {
            String paramId = param.getId();
            JsonRepresentation argRepr = arguments.getRepresentation(paramId, new Object[0]);
            if (argRepr == null && !param.isOptional()) {
                String reason = String.format("No argument found for (mandatory) parameter '%s'", paramId);
                arguments.mapPut("x-ro-invalidReason", reason);
                throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)arguments, (String)reason, (Object[])new Object[0]);
            }
            argList.add(argRepr);
        }
        return argList;
    }
}

