/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.util.Collection;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainServiceLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ListReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.TypeListReprRenderer;
import org.apache.isis.viewer.restfulobjects.server.ResourceContext;
import org.apache.isis.viewer.restfulobjects.server.resources.UserReprRenderer;
import org.apache.isis.viewer.restfulobjects.server.resources.VersionReprRenderer;

public class HomePageReprRenderer
extends ReprRendererAbstract<HomePageReprRenderer, Void> {
    HomePageReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.HOME_PAGE, representation);
    }

    public HomePageReprRenderer with(Void t) {
        return this;
    }

    public JsonRepresentation render() {
        if (this.includesSelf) {
            this.addLinkToSelf();
        }
        this.addLinkToUser(this.getRendererContext().getAuthenticationSession());
        this.addLinkToMenuBars();
        this.addLinkToServices(this.getRendererContext().getPersistenceSession().getServices());
        this.addLinkToVersion();
        this.addLinkToDomainTypes(((ResourceContext)this.getRendererContext()).getSpecificationLoader().allSpecifications());
        this.representation.mapPut("extensions", JsonRepresentation.newMap((String[])new String[0]));
        return this.representation;
    }

    private void addLinkToSelf() {
        JsonRepresentation link = LinkBuilder.newBuilder((RendererContext)this.rendererContext, (String)Rel.SELF.getName(), (RepresentationType)RepresentationType.HOME_PAGE, (String)"", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            HomePageReprRenderer renderer = new HomePageReprRenderer(this.getRendererContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToVersion() {
        JsonRepresentation link = LinkBuilder.newBuilder((RendererContext)this.getRendererContext(), (String)Rel.VERSION.getName(), (RepresentationType)RepresentationType.VERSION, (String)"version", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            VersionReprRenderer renderer = new VersionReprRenderer(this.getRendererContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToServices(List<ObjectAdapter> serviceAdapters) {
        JsonRepresentation link = LinkBuilder.newBuilder((RendererContext)this.getRendererContext(), (String)Rel.SERVICES.getName(), (RepresentationType)RepresentationType.LIST, (String)"services", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollowSpecs = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollowSpecs.matches(link)) {
            ListReprRenderer renderer = new ListReprRenderer(this.getRendererContext(), linkFollowSpecs, JsonRepresentation.newMap((String[])new String[0]));
            ((ListReprRenderer)renderer.usingLinkToBuilder((ObjectAdapterLinkTo)new DomainServiceLinkTo()).withLink(Rel.SELF, "services")).with(serviceAdapters);
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToUser(AuthenticationSession authenticationSession) {
        JsonRepresentation link = LinkBuilder.newBuilder((RendererContext)this.getRendererContext(), (String)Rel.USER.getName(), (RepresentationType)RepresentationType.USER, (String)"user", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            UserReprRenderer renderer = new UserReprRenderer(this.getRendererContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            renderer.with(authenticationSession);
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToMenuBars() {
        JsonRepresentation link = LinkBuilder.newBuilder((RendererContext)this.getRendererContext(), (String)Rel.MENUBARS.getName(), (RepresentationType)RepresentationType.MENUBARS, (String)"menuBars", (Object[])new Object[0]).build();
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToDomainTypes(Collection<ObjectSpecification> specifications) {
        JsonRepresentation link = LinkBuilder.newBuilder((RendererContext)this.getRendererContext(), (String)Rel.DOMAIN_TYPES.getName(), (RepresentationType)RepresentationType.TYPE_LIST, (String)"domain-types", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            TypeListReprRenderer renderer = new TypeListReprRenderer(this.getRendererContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            ((TypeListReprRenderer)renderer.withLink(Rel.SELF, "domain-types")).with(specifications);
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }
}

