/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.health.Health;
import org.apache.isis.applib.services.health.HealthCheckService;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.HealthAuthSession;
import org.apache.isis.core.runtime.sessiontemplate.AbstractIsisSessionTemplate;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.health.HealthResource;
import org.apache.isis.viewer.restfulobjects.rendering.Caching;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.Responses;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.util.JsonWriterUtil;
import org.apache.isis.viewer.restfulobjects.server.resources.HealthReprRenderer;
import org.apache.isis.viewer.restfulobjects.server.resources.ResourceAbstract;

public class HealthResourceServerside
extends ResourceAbstract
implements HealthResource {
    @GET
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/health"})
    public Response health() {
        Response[] responseHolder = new Response[1];
        HealthServiceSession template = new HealthServiceSession();
        HealthAuthSession authSession = new HealthAuthSession();
        template.execute((AuthenticationSession)authSession, responseHolder);
        return responseHolder[0];
    }

    public Response deleteHealthNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting the health resource is not allowed.", (Object[])new Object[0]);
    }

    public Response putHealthNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to the health resource is not allowed.", (Object[])new Object[0]);
    }

    public Response postHealthNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to the version resource is not allowed.", (Object[])new Object[0]);
    }

    private class HealthServiceSession
    extends AbstractIsisSessionTemplate {
        @Inject
        HealthCheckService healthService;

        private HealthServiceSession() {
        }

        protected void doExecuteWithTransaction(Object context) {
            Health health;
            super.doExecuteWithTransaction(context);
            HealthResourceServerside.this.init(RepresentationType.HEALTH, Where.NOWHERE, RepresentationService.Intent.NOT_APPLICABLE);
            HealthReprRenderer renderer = new HealthReprRenderer((RendererContext)HealthResourceServerside.this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
            if (this.healthService != null) {
                health = this.healthService.check();
                renderer.with(health);
            } else {
                health = Health.ok();
            }
            renderer.includesSelf();
            Response.ResponseBuilder responseBuilder = health.getResult() ? Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.NONE) : Response.serverError().entity((Object)JsonWriterUtil.jsonFor((Object)renderer.render())).cacheControl(Caching.NONE.getCacheControl());
            Response[] responseHolder = (Response[])context;
            responseHolder[0] = responseBuilder.build();
        }
    }
}

