/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.mappers.entity;

import com.google.common.collect.Lists;
import java.util.List;
import javax.jdo.JDOException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="exceptionDetail")
@XmlType(name="exceptionDetail", propOrder={"className", "message", "stackTrace", "causedBy"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExceptionDetail {
    private String className;
    private String message;
    @XmlElementWrapper
    @XmlElement(name="element")
    private List<String> stackTrace = Lists.newArrayList();
    private ExceptionDetail causedBy;

    private static String format(StackTraceElement stackTraceElement) {
        return stackTraceElement.toString();
    }

    public ExceptionDetail() {
    }

    public ExceptionDetail(Throwable ex) {
        StackTraceElement[] stackTraceElements;
        this.className = ex.getClass().getName();
        this.message = ex.getMessage();
        for (StackTraceElement stackTraceElement : stackTraceElements = ex.getStackTrace()) {
            this.stackTrace.add(ExceptionDetail.format(stackTraceElement));
        }
        Throwable cause = ExceptionDetail.causeOf(ex);
        if (cause != null && cause != ex) {
            this.causedBy = new ExceptionDetail(cause);
        }
    }

    private static Throwable causeOf(Throwable ex) {
        if (ex instanceof JDOException) {
            JDOException jdoException = (JDOException)ex;
            Throwable[] nestedExceptions = jdoException.getNestedExceptions();
            return nestedExceptions != null && nestedExceptions.length > 0 ? nestedExceptions[0] : null;
        }
        return ex.getCause();
    }
}

