/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.mappers;

import com.google.common.base.Throwables;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.viewer.restfulobjects.server.mappers.ExceptionMapperAbstract;

@Provider
public class ExceptionMapperForRuntimeException
extends ExceptionMapperAbstract<RuntimeException> {
    public Response toResponse(RuntimeException ex) {
        Throwable rootCause = Throwables.getRootCause((Throwable)ex);
        List causalChain = Throwables.getCausalChain((Throwable)ex);
        for (Throwable throwable : causalChain) {
            IsisSession currentSession;
            if (throwable != rootCause || (currentSession = this.getIsisSessionFactory().getCurrentSession()) == null) continue;
            IsisTransaction currentTransaction = currentSession.getPersistenceSession().getTransactionManager().getCurrentTransaction();
            currentTransaction.clearAbortCause();
        }
        return this.buildResponse(ex);
    }

    private IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

