/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.mappers;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.ExceptionWithBody;
import org.apache.isis.viewer.restfulobjects.rendering.ExceptionWithHttpStatusCode;
import org.apache.isis.viewer.restfulobjects.server.mappers.entity.ExceptionDetail;
import org.apache.isis.viewer.restfulobjects.server.mappers.entity.ExceptionPojo;
import org.apache.isis.viewer.restfulobjects.server.resources.serialization.SerializationStrategy;
import org.jboss.resteasy.spi.Failure;

public abstract class ExceptionMapperAbstract<T extends Throwable>
implements ExceptionMapper<T> {
    @Context
    protected HttpHeaders httpHeaders;

    Response buildResponse(T ex) {
        ExceptionWithBody exceptionWithBody;
        JsonRepresentation body;
        RestfulResponse.HttpStatusCode httpStatusCode = this.determineStatusCode(ex);
        String message = ExceptionMapperAbstract.messageFor(ex);
        if (ex instanceof ExceptionWithBody && (body = (exceptionWithBody = (ExceptionWithBody)ex).getBody()) != null) {
            return this.buildResponse(httpStatusCode, message, body);
        }
        ExceptionPojo exceptionPojo = new ExceptionPojo(httpStatusCode.getStatusCode(), message, this.detailIfRequired(httpStatusCode, (Throwable)ex));
        return this.buildResponse(httpStatusCode, exceptionPojo);
    }

    private Response buildResponse(RestfulResponse.HttpStatusCode httpStatusCode, String message, JsonRepresentation body) {
        Response.ResponseBuilder builder = Response.status((Response.StatusType)httpStatusCode.getJaxrsStatusType());
        if (message != null) {
            builder.header(RestfulResponse.Header.WARNING.getName(), (Object)RestfulResponse.Header.WARNING.render((Object)message));
        }
        SerializationStrategy serializationStrategy = SerializationStrategy.JSON;
        builder.type(serializationStrategy.type(RepresentationType.GENERIC));
        builder.entity((Object)body.toString());
        return builder.build();
    }

    private RestfulResponse.HttpStatusCode determineStatusCode(T ex) {
        RestfulResponse.HttpStatusCode statusCode;
        List chain = Throwables.getCausalChain(ex);
        if (ex instanceof Failure) {
            Failure failure = (Failure)ex;
            statusCode = RestfulResponse.HttpStatusCode.statusFor((int)failure.getErrorCode());
        } else if (!FluentIterable.from((Iterable)chain).filter(RecoverableException.class).isEmpty()) {
            statusCode = RestfulResponse.HttpStatusCode.OK;
        } else if (ex instanceof ExceptionWithHttpStatusCode) {
            ExceptionWithHttpStatusCode exceptionWithHttpStatusCode = (ExceptionWithHttpStatusCode)ex;
            statusCode = exceptionWithHttpStatusCode.getHttpStatusCode();
        } else {
            statusCode = RestfulResponse.HttpStatusCode.INTERNAL_SERVER_ERROR;
        }
        return statusCode;
    }

    private static String messageFor(Throwable ex) {
        List chain = Throwables.getCausalChain((Throwable)ex);
        Optional recoverableIfAny = FluentIterable.from((Iterable)chain).filter(RecoverableException.class).first();
        return (recoverableIfAny.isPresent() ? (Throwable)recoverableIfAny.get() : ex).getMessage();
    }

    private ExceptionDetail detailIfRequired(RestfulResponse.HttpStatusCode httpStatusCode, Throwable ex) {
        return httpStatusCode == RestfulResponse.HttpStatusCode.NOT_FOUND || httpStatusCode == RestfulResponse.HttpStatusCode.OK ? null : new ExceptionDetail(ex);
    }

    private Response buildResponse(RestfulResponse.HttpStatusCode httpStatusCode, ExceptionPojo exceptionPojo) {
        Response.ResponseBuilder builder = Response.status((Response.StatusType)httpStatusCode.getJaxrsStatusType());
        List acceptableMediaTypes = this.httpHeaders.getAcceptableMediaTypes();
        SerializationStrategy serializationStrategy = acceptableMediaTypes.contains(MediaType.APPLICATION_XML_TYPE) || acceptableMediaTypes.contains(RepresentationType.OBJECT_LAYOUT.getXmlMediaType()) ? SerializationStrategy.XML : SerializationStrategy.JSON;
        String message = exceptionPojo.getMessage();
        if (message != null) {
            builder.header(RestfulResponse.Header.WARNING.getName(), (Object)RestfulResponse.Header.WARNING.render((Object)message));
        }
        builder.type(serializationStrategy.type(RepresentationType.ERROR));
        builder.entity(serializationStrategy.entity(exceptionPojo));
        return builder.build();
    }
}

