/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.webapp.WebAppConstants;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulRequest;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext6;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.util.Util;

public class ResourceContext
implements RendererContext6 {
    private final HttpHeaders httpHeaders;
    private final UriInfo uriInfo;
    private final Request request;
    private final Providers providers;
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;
    private final SecurityContext securityContext;
    private final DeploymentCategory deploymentCategory;
    private final IsisConfiguration configuration;
    private final ServicesInjector servicesInjector;
    private final SpecificationLoader specificationLoader;
    private final AuthenticationSession authenticationSession;
    private final PersistenceSession persistenceSession;
    private List<List<String>> followLinks;
    private boolean validateOnly;
    private final Where where;
    private final RepresentationService.Intent intent;
    private final InteractionInitiatedBy interactionInitiatedBy;
    private final String urlUnencodedQueryString;
    private JsonRepresentation readQueryStringAsMap;
    private Set<Oid> rendered = Sets.newHashSet();
    private static final boolean HONOR_UI_HINTS_DEFAULT = false;
    private static final boolean OBJECT_PROPERTY_VALUES_ONLY_DEFAULT = false;
    private static final boolean SUPPRESS_DESCRIBED_BY_LINKS_DEFAULT = false;
    private static final boolean SUPPRESS_UPDATE_LINK_DEFAULT = false;
    private static final boolean SUPPRESS_MEMBER_ID_DEFAULT = false;
    private static final boolean SUPPRESS_MEMBER_LINKS_DEFAULT = false;
    private static final boolean SUPPRESS_MEMBER_EXTENSIONS_DEFAULT = false;
    private static final boolean SUPPRESS_MEMBER_DISABLED_REASON_DEFAULT = false;

    public ResourceContext(RepresentationType representationType, HttpHeaders httpHeaders, Providers providers, UriInfo uriInfo, Request request, Where where, RepresentationService.Intent intent, String urlUnencodedQueryStringIfAny, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SecurityContext securityContext, InteractionInitiatedBy interactionInitiatedBy) {
        this.httpHeaders = httpHeaders;
        this.providers = providers;
        this.uriInfo = uriInfo;
        this.request = request;
        this.where = where;
        this.intent = intent;
        this.urlUnencodedQueryString = urlUnencodedQueryStringIfAny;
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
        this.securityContext = securityContext;
        ServletContext servletContext = httpServletRequest.getServletContext();
        IsisSessionFactory isisSessionFactory = (IsisSessionFactory)servletContext.getAttribute(WebAppConstants.ISIS_SESSION_FACTORY);
        this.servicesInjector = isisSessionFactory.getServicesInjector();
        this.configuration = isisSessionFactory.getConfiguration();
        this.authenticationSession = isisSessionFactory.getCurrentSession().getAuthenticationSession();
        this.specificationLoader = isisSessionFactory.getSpecificationLoader();
        this.deploymentCategory = isisSessionFactory.getDeploymentCategory();
        this.persistenceSession = isisSessionFactory.getCurrentSession().getPersistenceSession();
        this.interactionInitiatedBy = interactionInitiatedBy;
        this.init(representationType);
    }

    void init(RepresentationType representationType) {
        this.getQueryStringAsJsonRepr();
        this.ensureDomainModelQueryParamSupported();
        this.followLinks = Collections.unmodifiableList((List)this.getArg(RestfulRequest.RequestParameter.FOLLOW_LINKS));
        this.validateOnly = (Boolean)this.getArg(RestfulRequest.RequestParameter.VALIDATE_ONLY);
    }

    private void ensureDomainModelQueryParamSupported() {
        RestfulRequest.DomainModel domainModel = (RestfulRequest.DomainModel)this.getArg(RestfulRequest.RequestParameter.DOMAIN_MODEL);
        if (domainModel != RestfulRequest.DomainModel.FORMAL) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"x-ro-domain-model of '%s' is not supported", (Object[])new Object[]{domainModel});
        }
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getUrlUnencodedQueryString() {
        return this.urlUnencodedQueryString;
    }

    public JsonRepresentation getQueryStringAsJsonRepr() {
        if (this.readQueryStringAsMap == null) {
            this.readQueryStringAsMap = this.requestArgsAsMap();
        }
        return this.readQueryStringAsMap;
    }

    protected JsonRepresentation requestArgsAsMap() {
        Map params = this.httpServletRequest.getParameterMap();
        if (ResourceContext.simpleQueryArgs(params)) {
            JsonRepresentation map = JsonRepresentation.newMap((String[])new String[0]);
            for (String paramName : params.keySet()) {
                String paramValue = ((String[])params.get(paramName))[0];
                String key = paramName.startsWith("x-ro") ? paramName : paramName + ".value";
                try {
                    int paramValueAsInt = Integer.parseInt(paramValue);
                    map.mapPut(key, paramValueAsInt);
                }
                catch (Exception ex) {
                    map.mapPut(key, ResourceContext.stripQuotes(paramValue));
                }
            }
            return map;
        }
        String queryString = this.getUrlUnencodedQueryString();
        return Util.readQueryStringAsMap((String)queryString);
    }

    static String stripQuotes(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.lastIndexOf("\""));
        }
        return str;
    }

    private static boolean simpleQueryArgs(Map<String, String[]> params) {
        if (params.isEmpty()) {
            return false;
        }
        for (String paramName : params.keySet()) {
            if (!"x-isis-querystring".equals(paramName) && !paramName.startsWith("{")) continue;
            return false;
        }
        return true;
    }

    public <Q> Q getArg(RestfulRequest.RequestParameter<Q> requestParameter) {
        JsonRepresentation queryStringJsonRepr = this.getQueryStringAsJsonRepr();
        return (Q)requestParameter.valueOf(queryStringJsonRepr);
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public Request getRequest() {
        return this.request;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return this.httpHeaders.getAcceptableMediaTypes();
    }

    public HttpServletResponse getServletResponse() {
        return this.httpServletResponse;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategory;
    }

    public InteractionInitiatedBy getInteractionInitiatedBy() {
        return this.interactionInitiatedBy;
    }

    public List<List<String>> getFollowLinks() {
        return this.followLinks;
    }

    public boolean isValidateOnly() {
        return this.validateOnly;
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    @Deprecated
    public AdapterManager getAdapterManager() {
        return this.persistenceSession;
    }

    public ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }

    public PersistenceSession getPersistenceSession() {
        return this.persistenceSession;
    }

    public List<ObjectAdapter> getServiceAdapters() {
        return this.persistenceSession.getServices();
    }

    public SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    public Where getWhere() {
        return this.where;
    }

    public RepresentationService.Intent getIntent() {
        return this.intent;
    }

    public boolean canEagerlyRender(ObjectAdapter objectAdapter) {
        Oid oid = objectAdapter.getOid();
        return this.rendered.add(oid);
    }

    public boolean honorUiHints() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.honorUiHints", false);
    }

    public boolean objectPropertyValuesOnly() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.objectPropertyValuesOnly", false);
    }

    public boolean suppressDescribedByLinks() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.suppressDescribedByLinks", false);
    }

    public boolean suppressUpdateLink() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.suppressUpdateLink", false);
    }

    public boolean suppressMemberId() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.suppressMemberId", false);
    }

    public boolean suppressMemberLinks() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.suppressMemberLinks", false);
    }

    public boolean suppressMemberExtensions() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.suppressMemberExtensions", false);
    }

    public boolean suppressMemberDisabledReason() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.suppressMemberDisabledReason", false);
    }

    public String urlFor(String url) {
        return this.getUriInfo().getBaseUri().toString() + url;
    }
}

