/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.service.support;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.jdosupport.IsisJdoSupport;
import org.apache.isis.applib.services.timestamp.HoldsUpdatedAt;
import org.apache.isis.applib.services.timestamp.HoldsUpdatedBy;
import org.apache.isis.applib.services.user.UserService;
import org.datanucleus.enhancement.Persistable;

@RequestScoped
@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class TimestampService
implements StoreLifecycleListener {
    @Inject
    UserService userService;
    @Inject
    ClockService clockService;
    @Inject
    IsisJdoSupport isisJdoSupport;

    @PostConstruct
    public void open() {
        this.isisJdoSupport.getJdoPersistenceManager().addInstanceLifecycleListener((InstanceLifecycleListener)this, null);
    }

    @PreDestroy
    public void close() {
        this.isisJdoSupport.getJdoPersistenceManager().removeInstanceLifecycleListener((InstanceLifecycleListener)this);
    }

    @Programmatic
    public void preStore(InstanceLifecycleEvent event) {
        Object pi = event.getPersistentInstance();
        if (pi instanceof Persistable) {
            if (pi instanceof HoldsUpdatedBy) {
                ((HoldsUpdatedBy)pi).setUpdatedBy(this.userService.getUser().getName());
            }
            if (pi instanceof HoldsUpdatedAt) {
                ((HoldsUpdatedAt)pi).setUpdatedAt(this.clockService.nowAsJavaSqlTimestamp());
            }
        }
    }

    @Programmatic
    public void postStore(InstanceLifecycleEvent event) {
    }
}

