/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.service.support;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.jdo.Extent;
import javax.jdo.PersistenceManager;
import javax.jdo.datastore.JDOConnection;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.persistence.ObjectPersistenceException;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.objectstore.jdo.applib.service.support.IsisJdoSupport;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.query.typesafe.BooleanExpression;
import org.datanucleus.query.typesafe.TypesafeQuery;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class IsisJdoSupportImpl
implements IsisJdoSupport {
    @Inject
    IsisSessionFactory isisSessionFactory;

    @Programmatic
    public <T> T refresh(T domainObject) {
        ObjectAdapter adapter = this.getPersistenceSession().adapterFor(domainObject);
        this.getPersistenceSession().refreshRoot(adapter);
        return domainObject;
    }

    @Programmatic
    public void ensureLoaded(Collection<?> domainObjects) {
        this.getPersistenceSession().getPersistenceManager().retrieveAll(domainObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Programmatic
    public List<Map<String, Object>> executeSql(String sql) {
        try (JDOConnection dataStoreConnection = this.getJdoPersistenceManager().getDataStoreConnection();){
            Object connectionObj = dataStoreConnection.getNativeConnection();
            if (!(connectionObj instanceof Connection)) {
                List<Map<String, Object>> list = null;
                return list;
            }
            Connection connection = (Connection)connectionObj;
            List<Map<String, Object>> list = IsisJdoSupportImpl.executeSql(connection, sql);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Programmatic
    public Integer executeUpdate(String sql) {
        try (JDOConnection dataStoreConnection = this.getJdoPersistenceManager().getDataStoreConnection();){
            Object connectionObj = dataStoreConnection.getNativeConnection();
            if (!(connectionObj instanceof Connection)) {
                Integer n = null;
                return n;
            }
            Connection connection = (Connection)connectionObj;
            Integer n = IsisJdoSupportImpl.executeUpdate(connection, sql);
            return n;
        }
    }

    private static List<Map<String, Object>> executeSql(Connection connection, String sql) {
        ArrayList rows = Lists.newArrayList();
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                LinkedHashMap row = Maps.newLinkedHashMap();
                int columnCount = rsmd.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    Object val = rs.getObject(i + 1);
                    row.put(rsmd.getColumnName(i + 1), val);
                }
                rows.add(row);
            }
        }
        catch (SQLException ex) {
            throw new ObjectPersistenceException("Failed to executeSql: " + sql, (Throwable)ex);
        }
        return rows;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int executeUpdate(Connection connection, String sql) {
        try (Statement statement = connection.createStatement();){
            int n = statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException ex) {
            throw new ObjectPersistenceException("Failed to executeSql: " + sql, (Throwable)ex);
        }
    }

    @Programmatic
    public void deleteAll(Class<?> ... pcClasses) {
        for (Class<?> pcClass : pcClasses) {
            Extent extent = this.getJdoPersistenceManager().getExtent(pcClass);
            final ArrayList instances = Lists.newArrayList((Iterator)extent.iterator());
            try {
                AdapterManager.ConcurrencyChecking.executeWithConcurrencyCheckingDisabled((Callable)new Callable<Void>(){

                    @Override
                    public Void call() {
                        IsisJdoSupportImpl.this.getJdoPersistenceManager().deletePersistentAll((Collection)instances);
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                throw new FatalException((Throwable)ex);
            }
        }
    }

    @Programmatic
    public <T> List<T> executeQuery(Class<T> cls, BooleanExpression expression) {
        TypesafeQuery query = this.newTypesafeQuery(cls).filter(expression);
        return IsisJdoSupportImpl.executeListAndClose(query);
    }

    @Programmatic
    public <T> T executeQueryUnique(Class<T> cls, BooleanExpression expression) {
        TypesafeQuery query = this.newTypesafeQuery(cls).filter(expression);
        return IsisJdoSupportImpl.executeUniqueAndClose(query);
    }

    @Programmatic
    public <T> TypesafeQuery<T> newTypesafeQuery(Class<T> cls) {
        return ((JDOPersistenceManager)this.getJdoPersistenceManager()).newTypesafeQuery(cls);
    }

    private static <T> List<T> executeListAndClose(TypesafeQuery<T> query) {
        List elements = query.executeList();
        ArrayList list = Lists.newArrayList((Iterable)elements);
        query.closeAll();
        return list;
    }

    private static <T> T executeUniqueAndClose(TypesafeQuery<T> query) {
        Object result = query.executeUnique();
        query.closeAll();
        return (T)result;
    }

    protected PersistenceSession getPersistenceSession() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }

    protected ServicesInjector getServicesInjector() {
        return this.isisSessionFactory.getServicesInjector();
    }

    @Programmatic
    public PersistenceManager getJdoPersistenceManager() {
        return this.getPersistenceSession().getPersistenceManager();
    }
}

