/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.jdo.annotations.IdentityType;
import javax.jdo.identity.ByteIdentity;
import javax.jdo.identity.IntIdentity;
import javax.jdo.identity.LongIdentity;
import javax.jdo.identity.ObjectIdentity;
import javax.jdo.identity.StringIdentity;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.datanucleus.identity.DatastoreId;

public final class JdoObjectIdSerializer {
    private static final char SEPARATOR = '_';
    private static List<String> dnPrefixes = Arrays.asList("S", "I", "L", "M", "B");

    private JdoObjectIdSerializer() {
    }

    public static String toOidIdentifier(Object jdoOid) {
        DatastoreId dnOid;
        Object keyValue;
        ObjectIdentity id;
        Object keyAsObject;
        if (jdoOid instanceof ByteIdentity) {
            return "b_" + jdoOid;
        }
        if (jdoOid instanceof IntIdentity) {
            return "i_" + jdoOid;
        }
        if (jdoOid instanceof StringIdentity) {
            return "s_" + jdoOid;
        }
        if (jdoOid instanceof LongIdentity) {
            return "l_" + jdoOid;
        }
        if (jdoOid instanceof ObjectIdentity && (keyAsObject = (id = (ObjectIdentity)jdoOid).getKeyAsObject()) instanceof UUID) {
            UUID uuid = (UUID)keyAsObject;
            return "u_" + uuid.toString();
        }
        if (jdoOid instanceof DatastoreId && ((keyValue = (dnOid = (DatastoreId)jdoOid).getKeyAsObject()) instanceof String || keyValue instanceof Long || keyValue instanceof BigDecimal || keyValue instanceof BigInteger || keyValue instanceof Integer)) {
            return "" + keyValue;
        }
        return jdoOid.getClass().getName() + '_' + jdoOid.toString();
    }

    public static Object toJdoObjectId(RootOid oid) {
        String idStr = oid.getIdentifier();
        int separatorIdx = idStr.indexOf(95);
        ObjectSpecification spec = JdoObjectIdSerializer.getSpecificationLoader().lookupBySpecId(oid.getObjectSpecId());
        JdoPersistenceCapableFacet jdoPcFacet = (JdoPersistenceCapableFacet)spec.getFacet(JdoPersistenceCapableFacet.class);
        if (separatorIdx != -1) {
            String distinguisher = idStr.substring(0, separatorIdx);
            String keyStr = idStr.substring(separatorIdx + 1);
            boolean isApplicationIdentity = JdoObjectIdSerializer.isApplicationIdentity(jdoPcFacet);
            if ("s".equals(distinguisher)) {
                if (isApplicationIdentity) {
                    return keyStr;
                }
                return new StringIdentity(JdoObjectIdSerializer.objectTypeClassFor(oid), keyStr);
            }
            if ("i".equals(distinguisher)) {
                if (isApplicationIdentity) {
                    return Integer.parseInt(keyStr);
                }
                return new IntIdentity(JdoObjectIdSerializer.objectTypeClassFor(oid), keyStr);
            }
            if ("l".equals(distinguisher)) {
                if (isApplicationIdentity) {
                    return Long.parseLong(keyStr);
                }
                return new LongIdentity(JdoObjectIdSerializer.objectTypeClassFor(oid), keyStr);
            }
            if ("b".equals(distinguisher)) {
                if (isApplicationIdentity) {
                    return Byte.parseByte(keyStr);
                }
                return new ByteIdentity(JdoObjectIdSerializer.objectTypeClassFor(oid), keyStr);
            }
            if ("u".equals(distinguisher)) {
                if (isApplicationIdentity) {
                    return UUID.fromString(keyStr);
                }
                return new ObjectIdentity(JdoObjectIdSerializer.objectTypeClassFor(oid), (Object)UUID.fromString(keyStr));
            }
            if (dnPrefixes.contains(distinguisher)) {
                return keyStr + "[OID]" + spec.getFullIdentifier();
            }
            String clsName = distinguisher;
            try {
                Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(clsName);
                Constructor<?> cons = cls.getConstructor(String.class);
                Object dnOid = cons.newInstance(keyStr);
                return dnOid.toString();
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new Exception(e);
            }
        }
        return idStr + "[OID]" + spec.getFullIdentifier();
    }

    protected static boolean isApplicationIdentity(JdoPersistenceCapableFacet jdoPcFacet) {
        return jdoPcFacet != null && jdoPcFacet.getIdentityType() == IdentityType.APPLICATION;
    }

    private static Class<?> objectTypeClassFor(RootOid oid) {
        ObjectSpecId objectSpecId = oid.getObjectSpecId();
        ObjectSpecification spec = JdoObjectIdSerializer.getSpecificationLoader().lookupBySpecId(objectSpecId);
        Class correspondingClass = spec.getCorrespondingClass();
        return correspondingClass;
    }

    private static SpecificationLoader getSpecificationLoader() {
        return JdoObjectIdSerializer.getIsisSessionFactory().getSpecificationLoader();
    }

    static IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    public static class Exception
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public Exception(java.lang.Exception ex) {
            super(ex);
        }
    }
}

