/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence.queries;

import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(QueryUtil.class);

    private QueryUtil() {
    }

    public static Query createQuery(PersistenceManager persistenceManager, String alias, String select, ObjectSpecification specification, String whereClause) {
        StringBuilder buf = new StringBuilder(128);
        QueryUtil.appendSelect(buf, select, alias);
        QueryUtil.appendFrom(buf, specification, alias);
        QueryUtil.appendWhere(buf, whereClause);
        String queryString = buf.toString();
        LOG.debug("creating query: {}", (Object)queryString);
        Query jdoQuery = persistenceManager.newQuery(queryString);
        jdoQuery.addExtension("datanucleus.multivaluedFetch", (Object)"none");
        return jdoQuery;
    }

    private static StringBuilder appendSelect(StringBuilder buf, String select, String alias) {
        if (select != null) {
            buf.append(select);
        } else {
            buf.append("select ");
        }
        buf.append(" ");
        return buf;
    }

    private static void appendWhere(StringBuilder buf, String whereClause) {
        if (whereClause == null) {
            return;
        }
        buf.append(" where ").append(whereClause);
    }

    private static StringBuilder appendFrom(StringBuilder buf, ObjectSpecification specification, String alias) {
        return buf.append("from ").append(specification.getFullIdentifier()).append(" as ").append(alias);
    }
}

