/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence.queries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryProcessor;
import org.datanucleus.enhancement.Persistable;

public abstract class PersistenceQueryProcessorAbstract<T extends PersistenceQuery>
implements PersistenceQueryProcessor<T> {
    final PersistenceSession persistenceSession;

    protected PersistenceQueryProcessorAbstract(PersistenceSession persistenceSession) {
        this.persistenceSession = persistenceSession;
    }

    protected List<ObjectAdapter> loadAdapters(List<?> pojos) {
        ArrayList adapters = Lists.newArrayList();
        for (Object pojo : pojos) {
            ObjectAdapter adapter;
            if (pojo instanceof Persistable) {
                this.persistenceSession.initializeMapAndCheckConcurrency((Persistable)pojo);
                adapter = this.persistenceSession.getAdapterFor(pojo);
            } else {
                adapter = this.persistenceSession.adapterFor(pojo);
            }
            Assert.assertNotNull((Object)adapter);
            adapters.add(adapter);
        }
        return adapters;
    }
}

