/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence.queries;

import java.util.List;
import javax.jdo.Query;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindAllInstances;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryProcessorAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceQueryFindAllInstancesProcessor
extends PersistenceQueryProcessorAbstract<PersistenceQueryFindAllInstances> {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceQueryFindAllInstancesProcessor.class);

    public PersistenceQueryFindAllInstancesProcessor(PersistenceSession persistenceSession) {
        super(persistenceSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectAdapter> process(PersistenceQueryFindAllInstances persistenceQuery) {
        ObjectSpecification specification = persistenceQuery.getSpecification();
        Class cls = specification.getCorrespondingClass();
        Query jdoQuery = this.persistenceSession.newJdoQuery(cls);
        jdoQuery.addExtension("datanucleus.multivaluedFetch", (Object)"none");
        if (LOG.isDebugEnabled()) {
            LOG.debug("allInstances(): class={}", (Object)specification.getFullIdentifier());
        }
        try {
            List pojos = (List)jdoQuery.execute();
            List<ObjectAdapter> list = this.loadAdapters(pojos);
            return list;
        }
        finally {
            jdoQuery.closeAll();
        }
    }
}

