/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisConfigurationForJdoIntegTests
extends IsisConfigurationDefault {
    private static final Logger LOG = LoggerFactory.getLogger(IsisConfigurationForJdoIntegTests.class);
    private static final String REGISTER_ENTITIES_PACKAGE_PREFIX = "isis.persistor.datanucleus.RegisterEntities.packagePrefix";

    public IsisConfigurationForJdoIntegTests() {
        this(null);
    }

    public IsisConfigurationForJdoIntegTests(ResourceStreamSource resourceStreamSource) {
        super(resourceStreamSource);
        HashMap map = Maps.newHashMap();
        AppManifest.Util.withJavaxJdoRunInMemoryProperties((Map)map);
        AppManifest.Util.withDataNucleusProperties((Map)map);
        AppManifest.Util.withIsisIntegTestProperties((Map)map);
        this.add(IsisConfigurationForJdoIntegTests.asProperties(map), IsisConfigurationDefault.ContainsPolicy.IGNORE);
    }

    private static Properties asProperties(Map<String, String> map) {
        Properties properties = new Properties();
        properties.putAll(map);
        return properties;
    }

    @Programmatic
    public final IsisConfigurationForJdoIntegTests addDataNucleusProperty(String key, String value) {
        this.add("isis.persistor.datanucleus.impl." + key, value);
        return this;
    }

    @Programmatic
    public final IsisConfigurationForJdoIntegTests putDataNucleusProperty(String key, String value) {
        this.put("isis.persistor.datanucleus.impl." + key, value);
        return this;
    }

    @Programmatic
    public final IsisConfigurationForJdoIntegTests addRegisterEntitiesPackagePrefix(String ... packagePrefix) {
        String commaSeparated = Joiner.on((char)',').join((Object[])packagePrefix);
        this.add(REGISTER_ENTITIES_PACKAGE_PREFIX, commaSeparated);
        return this;
    }

    @Programmatic
    public final IsisConfigurationForJdoIntegTests putRegisterEntitiesPackagePrefix(String ... packagePrefix) {
        String commaSeparated = Joiner.on((char)',').join((Object[])packagePrefix);
        this.put(REGISTER_ENTITIES_PACKAGE_PREFIX, commaSeparated);
        return this;
    }

    @Deprecated
    public static Map<String, String> withJavaxJdoRunInMemoryProperties(Map<String, String> map) {
        return AppManifest.Util.withJavaxJdoRunInMemoryProperties(map);
    }

    @Deprecated
    public static Map<String, String> withIsisIntegTestProperties(Map<String, String> map) {
        return AppManifest.Util.withIsisIntegTestProperties(map);
    }
}

