/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.config.NotFoundPolicy;
import org.apache.isis.core.commons.configbuilder.IsisConfigurationBuilder;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.apache.isis.core.commons.resource.ResourceStreamSourceContextLoaderClassPath;
import org.apache.isis.core.commons.resource.ResourceStreamSourceCurrentClassClassPath;
import org.apache.isis.core.commons.resource.ResourceStreamSourceFileSystem;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.runtime.logging.IsisLoggingConfigurer;
import org.apache.isis.core.runtime.runner.IsisInjectModule;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerInitParameters;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSessionFactoryBuilder;
import org.apache.isis.core.webapp.WebAppConstants;
import org.apache.isis.core.webapp.config.ResourceStreamSourceForWebInf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisWebAppBootstrapper
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(IsisWebAppBootstrapper.class);
    private final IsisLoggingConfigurer loggingConfigurer = new IsisLoggingConfigurer();
    @Inject
    private IsisSessionFactory isisSessionFactory;

    public static IsisSessionFactoryBuilder getSystemBoundTo(ServletContext servletContext) {
        Object system = servletContext.getAttribute(WebAppConstants.ISIS_SESSION_FACTORY);
        return (IsisSessionFactoryBuilder)system;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            ServletContext servletContext = servletContextEvent.getServletContext();
            String webInfDir = servletContext.getRealPath("/WEB-INF");
            this.loggingConfigurer.configureLogging(webInfDir, new String[0]);
            IsisConfigurationBuilder isisConfigurationBuilder = this.obtainIsisConfigurationBuilder(servletContext);
            isisConfigurationBuilder.addDefaultConfigurationResourcesAndPrimers();
            DeploymentType deploymentType = this.determineDeploymentType(servletContext, isisConfigurationBuilder);
            this.addConfigurationResourcesForDeploymentType(isisConfigurationBuilder, deploymentType);
            String webappDir = servletContext.getRealPath("/");
            isisConfigurationBuilder.add("application.webapp.dir", webappDir);
            IsisConfigurationDefault isisConfiguration = isisConfigurationBuilder.getConfiguration();
            DeploymentCategory deploymentCategory = deploymentType.getDeploymentCategory();
            IsisInjectModule isisModule = new IsisInjectModule(deploymentCategory, isisConfiguration);
            Injector injector = Guice.createInjector((Module[])new Module[]{isisModule});
            injector.injectMembers((Object)this);
            servletContext.setAttribute(WebAppConstants.ISIS_SESSION_FACTORY, (Object)this.isisSessionFactory);
        }
        catch (RuntimeException e) {
            LOG.error("startup failed", (Throwable)e);
            throw e;
        }
        LOG.info("server started");
    }

    protected IsisConfigurationBuilder obtainIsisConfigurationBuilder(ServletContext servletContext) {
        return IsisWebAppBootstrapper.obtainConfigBuilderFrom(servletContext);
    }

    public static IsisConfigurationBuilder obtainConfigBuilderFrom(ServletContext servletContext) {
        IsisConfigurationBuilder isisConfigurationBuilder = IsisWebAppBootstrapper.lookupIsisConfigurationBuilder(servletContext);
        isisConfigurationBuilder.primeWith((IsisConfigurationBuilder.Primer)new OptionHandlerInitParameters(servletContext));
        IsisWebAppBootstrapper.addResourceStreamSources(servletContext, isisConfigurationBuilder);
        return isisConfigurationBuilder;
    }

    public static IsisConfigurationBuilder lookupIsisConfigurationBuilder(ServletContext servletContext) {
        IsisConfigurationBuilder isisConfigurationBuilder = (IsisConfigurationBuilder)servletContext.getAttribute("isis.configurationBuilder");
        if (isisConfigurationBuilder == null) {
            isisConfigurationBuilder = new IsisConfigurationBuilder();
        }
        return isisConfigurationBuilder;
    }

    private static void addResourceStreamSources(ServletContext servletContext, IsisConfigurationBuilder isisConfigurationBuilder) {
        String configLocation = servletContext.getInitParameter("isis.config.dir");
        if (configLocation != null) {
            LOG.info("Config override location: {}", (Object)configLocation);
            isisConfigurationBuilder.addResourceStreamSource(ResourceStreamSourceFileSystem.create((String)configLocation));
        } else {
            LOG.info("Config override location: No override location configured");
            isisConfigurationBuilder.addResourceStreamSource((ResourceStreamSource)ResourceStreamSourceContextLoaderClassPath.create());
            isisConfigurationBuilder.addResourceStreamSource((ResourceStreamSource)new ResourceStreamSourceCurrentClassClassPath());
            isisConfigurationBuilder.addResourceStreamSource((ResourceStreamSource)new ResourceStreamSourceForWebInf(servletContext));
        }
    }

    private Injector createGuiceInjector(IsisConfigurationDefault isisConfiguration, DeploymentCategory deploymentCategory) {
        IsisInjectModule isisModule = new IsisInjectModule(deploymentCategory, isisConfiguration);
        return Guice.createInjector((Module[])new Module[]{isisModule});
    }

    protected DeploymentType determineDeploymentType(ServletContext servletContext, IsisConfigurationBuilder isisConfigurationBuilder) {
        String deploymentTypeStr = this.determineDeploymentTypeStr(servletContext, isisConfigurationBuilder);
        return DeploymentType.lookup(deploymentTypeStr);
    }

    private String determineDeploymentTypeStr(ServletContext servletContext, IsisConfigurationBuilder isisConfigurationBuilder) {
        String deploymentTypeStr = servletContext.getInitParameter("deploymentType");
        if (deploymentTypeStr != null) {
            return deploymentTypeStr;
        }
        deploymentTypeStr = servletContext.getInitParameter("isis.deploymentType");
        if (deploymentTypeStr != null) {
            return deploymentTypeStr;
        }
        deploymentTypeStr = isisConfigurationBuilder.peekConfiguration().getString("isis.deploymentType");
        if (deploymentTypeStr != null) {
            return deploymentTypeStr;
        }
        return WebAppConstants.DEPLOYMENT_TYPE_DEFAULT;
    }

    protected void addConfigurationResourcesForDeploymentType(IsisConfigurationBuilder isisConfigurationBuilder, DeploymentType deploymentType) {
        String resourceName = deploymentType.name().toLowerCase() + ".properties";
        isisConfigurationBuilder.addConfigurationResource(resourceName, NotFoundPolicy.CONTINUE, IsisConfigurationDefault.ContainsPolicy.IGNORE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent ev) {
        LOG.info("server shutting down");
        ServletContext servletContext = ev.getServletContext();
        try {
            IsisSessionFactory isisSessionFactory = (IsisSessionFactory)servletContext.getAttribute(WebAppConstants.ISIS_SESSION_FACTORY);
            if (isisSessionFactory != null) {
                LOG.info("calling system shutdown");
                isisSessionFactory.destroyServicesAndShutdown();
            }
        }
        finally {
            servletContext.removeAttribute(WebAppConstants.ISIS_SESSION_FACTORY);
            LOG.info("server shut down");
        }
    }
}

