/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategy;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategyDefault;
import org.apache.isis.core.webapp.content.ResourceCachingFilter;

public class IsisSessionFilter
implements Filter {
    public static final String AUTHENTICATION_SESSION_STRATEGY_KEY = "authenticationSessionStrategy";
    public static final String AUTHENTICATION_SESSION_STRATEGY_DEFAULT = AuthenticationSessionStrategyDefault.class.getName();
    public static final String LOGON_PAGE_KEY = "logonPage";
    public static final String WHEN_NO_SESSION_KEY = "whenNoSession";
    public static final String PASS_THRU_KEY = "passThru";
    public static final String RESTRICTED_KEY = "restricted";
    public static final String REDIRECT_TO_ON_EXCEPTION_KEY = "redirectToOnException";
    public static final String IGNORE_EXTENSIONS_KEY = "ignoreExtensions";
    private static final Function<String, Pattern> STRING_TO_PATTERN = new Function<String, Pattern>(){

        public Pattern apply(String input) {
            return Pattern.compile(".*\\." + input);
        }
    };
    public static final String QUERY_STRING_FORCE_LOGOUT = "__isis_force_logout";
    private List<String> passThruList = Collections.emptyList();
    private AuthenticationSessionStrategy authSessionStrategy;
    private List<String> restrictedPaths;
    private WhenNoSession whenNotAuthenticated;
    private String redirectToOnException;
    private Collection<Pattern> ignoreExtensions;

    static void redirect(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String redirectTo) throws IOException {
        httpResponse.sendRedirect(StringExtensions.combinePath((String)httpRequest.getContextPath(), (String)redirectTo));
    }

    public void init(FilterConfig config) throws ServletException {
        this.authSessionStrategy = IsisSessionFilter.lookup(config.getInitParameter(AUTHENTICATION_SESSION_STRATEGY_KEY));
        this.lookupWhenNoSession(config);
        this.lookupPassThru(config);
        this.lookupRedirectToOnException(config);
        this.lookupIgnoreExtensions(config);
    }

    public static AuthenticationSessionStrategy lookup(String authLookupStrategyClassName) {
        if (authLookupStrategyClassName == null) {
            authLookupStrategyClassName = AUTHENTICATION_SESSION_STRATEGY_DEFAULT;
        }
        return (AuthenticationSessionStrategy)InstanceUtil.createInstance((String)authLookupStrategyClassName, (Object[])new Object[0]);
    }

    private void lookupWhenNoSession(FilterConfig config) {
        String whenNoSessionStr = config.getInitParameter(WHEN_NO_SESSION_KEY);
        String logonPage = config.getInitParameter(LOGON_PAGE_KEY);
        if (logonPage != null) {
            if (whenNoSessionStr != null) {
                throw new IllegalStateException(String.format("The init-param '%s' is only provided for backwards compatibility; remove if the init-param '%s' has been specified", LOGON_PAGE_KEY, WHEN_NO_SESSION_KEY));
            }
            this.whenNotAuthenticated = WhenNoSession.RESTRICTED;
            this.restrictedPaths = Lists.newArrayList((Object[])new String[]{logonPage});
            return;
        }
        this.whenNotAuthenticated = WhenNoSession.lookup(whenNoSessionStr);
        if (this.whenNotAuthenticated == WhenNoSession.RESTRICTED) {
            String restrictedPathsStr = config.getInitParameter(RESTRICTED_KEY);
            if (restrictedPathsStr == null) {
                throw new IllegalStateException(String.format("Require an init-param of '%s' key to be set.", RESTRICTED_KEY));
            }
            this.restrictedPaths = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)restrictedPathsStr));
        }
    }

    void lookupPassThru(FilterConfig config) {
        this.passThruList = this.lookupAndParsePassThru(config);
    }

    List<String> lookupAndParsePassThru(FilterConfig config) {
        String passThru = config.getInitParameter(PASS_THRU_KEY);
        return passThru != null && !passThru.equals("") ? Arrays.asList(passThru.split(",")) : Collections.emptyList();
    }

    private void lookupRedirectToOnException(FilterConfig config) {
        this.redirectToOnException = config.getInitParameter(REDIRECT_TO_ON_EXCEPTION_KEY);
    }

    private void lookupIgnoreExtensions(FilterConfig config) {
        this.ignoreExtensions = Collections.unmodifiableCollection(IsisSessionFilter.parseIgnorePatterns(config));
    }

    private static Collection<Pattern> parseIgnorePatterns(FilterConfig config) {
        String ignoreExtensionsStr = config.getInitParameter(IGNORE_EXTENSIONS_KEY);
        if (ignoreExtensionsStr != null) {
            ArrayList ignoreExtensions = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)ignoreExtensionsStr));
            return Collections2.transform((Collection)ignoreExtensions, STRING_TO_PATTERN);
        }
        return Lists.newArrayList();
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        IsisSessionFilter.ensureMetamodelIsValid();
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        IsisSessionFactory sessionFactory = this.isisSessionFactoryFrom(httpServletRequest);
        try {
            String queryString = httpServletRequest.getQueryString();
            if (queryString != null && queryString.contains(QUERY_STRING_FORCE_LOGOUT)) {
                this.authSessionStrategy.invalidate(httpServletRequest, httpServletResponse);
                return;
            }
            if (this.requestIsIgnoreExtension(this, httpServletRequest) || ResourceCachingFilter.isCachedResource((HttpServletRequest)httpServletRequest)) {
                chain.doFilter(request, response);
                return;
            }
            if (this.requestIsPassThru(httpServletRequest)) {
                chain.doFilter(request, response);
                return;
            }
            AuthenticationSession authSession = this.authSessionStrategy.lookupValid(httpServletRequest, httpServletResponse);
            if (authSession != null) {
                this.authSessionStrategy.bind(httpServletRequest, httpServletResponse, authSession);
                sessionFactory.openSession(authSession);
                chain.doFilter(request, response);
                return;
            }
            try {
                this.whenNotAuthenticated.handle(this, httpServletRequest, httpServletResponse, chain);
            }
            catch (IOException | RuntimeException | ServletException ex) {
                if (this.redirectToOnException != null) {
                    IsisSessionFilter.redirect(httpServletRequest, httpServletResponse, this.redirectToOnException);
                    sessionFactory.closeSession();
                    return;
                }
                throw ex;
            }
        }
        finally {
            sessionFactory.closeSession();
        }
    }

    private static void ensureMetamodelIsValid() {
        MetaModelInvalidException ex = IsisContext.getMetaModelInvalidExceptionIfAny();
        if (ex != null) {
            Set validationErrors = ex.getValidationErrors();
            StringBuilder buf = new StringBuilder();
            for (String validationError : validationErrors) {
                buf.append(validationError).append("\n");
            }
            throw new IllegalStateException("Metamodel validation errors: \n" + buf.toString());
        }
    }

    protected boolean requestIsPassThru(HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        for (String passThru : this.passThruList) {
            if (!requestURI.startsWith(passThru)) continue;
            return true;
        }
        return false;
    }

    private boolean requestIsIgnoreExtension(IsisSessionFilter filter, HttpServletRequest httpRequest) {
        String servletPath = httpRequest.getServletPath();
        for (Pattern extension : filter.ignoreExtensions) {
            if (!extension.matcher(servletPath).matches()) continue;
            return true;
        }
        return false;
    }

    private IsisSessionFactory isisSessionFactoryFrom(HttpServletRequest httpServletRequest) {
        return IsisContext.getSessionFactory();
    }

    public static enum WhenNoSession {
        UNAUTHORIZED("unauthorized"){

            @Override
            public void handle(IsisSessionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                httpResponse.sendError(401);
            }
        }
        ,
        BASIC_AUTH_CHALLENGE("basicAuthChallenge"){

            @Override
            public void handle(IsisSessionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"Apache Isis\"");
                httpResponse.sendError(401);
            }
        }
        ,
        AUTO("auto"){

            @Override
            public void handle(IsisSessionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                if (this.fromWebBrowser(httpRequest)) {
                    httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"Apache Isis\"");
                }
                httpResponse.sendError(401);
            }

            private boolean fromWebBrowser(HttpServletRequest httpRequest) {
                String accept = httpRequest.getHeader("Accept");
                return accept.contains("text/html");
            }
        }
        ,
        CONTINUE("continue"){

            @Override
            public void handle(IsisSessionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
        }
        ,
        RESTRICTED("restricted"){

            @Override
            public void handle(IsisSessionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                if (filter.restrictedPaths.contains(httpRequest.getServletPath())) {
                    chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                    return;
                }
                IsisSessionFilter.redirect(httpRequest, httpResponse, (String)filter.restrictedPaths.get(0));
            }
        };

        private final String initParamValue;

        private WhenNoSession(String initParamValue) {
            this.initParamValue = initParamValue;
        }

        public static WhenNoSession lookup(String whenNoSessionStr) {
            for (WhenNoSession wns : WhenNoSession.values()) {
                if (!wns.initParamValue.equals(whenNoSessionStr)) continue;
                return wns;
            }
            throw new IllegalStateException("require an init-param of 'whenNoSession', taking a value of " + WhenNoSession.values());
        }

        public abstract void handle(IsisSessionFilter var1, HttpServletRequest var2, HttpServletResponse var3, FilterChain var4) throws IOException, ServletException;
    }
}

