/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.viewer.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractServletOrFilterMapping {
    private final Class<?> servletOrFilterClass;
    private final List<String> pathSpecs;
    private final Map<String, String> initParams;

    public AbstractServletOrFilterMapping(Class<?> servletOrFilterClass, String ... pathSpecs) {
        this(servletOrFilterClass, Collections.EMPTY_MAP, pathSpecs);
    }

    public AbstractServletOrFilterMapping(Class<?> servletOrFilterClass, Map<String, String> initParams, String ... pathSpecs) {
        this.servletOrFilterClass = servletOrFilterClass;
        this.initParams = initParams;
        this.pathSpecs = new ArrayList<String>(Arrays.asList(pathSpecs));
    }

    protected Class<?> getServletOrFilterClass() {
        return this.servletOrFilterClass;
    }

    public Map<String, String> getInitParams() {
        return Collections.unmodifiableMap(this.initParams);
    }

    public List<String> getPathSpecs() {
        return Collections.unmodifiableList(this.pathSpecs);
    }
}

