/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.systemusinginstallers;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.jdo.annotations.PersistenceCapable;
import javax.xml.bind.annotation.XmlElement;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.Mixin;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.ViewModel;
import org.apache.isis.applib.annotation.ViewModelLayout;
import org.apache.isis.applib.fixturescripts.DiscoverableFixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.services.classdiscovery.ClassDiscoveryServiceUsingReflections;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.layoutmetadata.LayoutMetadataReader;
import org.apache.isis.core.metamodel.progmodel.FacetFactorySet;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.ReflectorConstants;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.services.ServicesInstallerFromConfigurationAndAnnotation;
import org.apache.isis.core.runtime.system.IsisSystemException;
import org.apache.isis.progmodels.dflt.JavaReflectorHelper;
import org.apache.isis.progmodels.dflt.ProgrammingModelFacetsJava5;
import org.reflections.Reflections;
import org.reflections.vfs.Vfs;

public abstract class IsisComponentProvider {
    private final AppManifest appManifest;
    private final IsisConfigurationDefault configuration;
    protected final List<Object> services;
    protected final AuthenticationManager authenticationManager;
    protected final AuthorizationManager authorizationManager;

    public IsisComponentProvider(AppManifest appManifest, IsisConfiguration configuration, AuthenticationManager authenticationManager, AuthorizationManager authorizationManager) {
        if (appManifest == null) {
            throw new IllegalArgumentException("AppManifest is required");
        }
        this.appManifest = appManifest;
        this.configuration = (IsisConfigurationDefault)configuration;
        this.putAppManifestKey(appManifest);
        this.findAndRegisterTypes(appManifest);
        this.specifyServicesAndRegisteredEntitiesUsing(appManifest);
        this.addToConfigurationUsing(appManifest);
        this.services = new ServicesInstallerFromConfigurationAndAnnotation(this.getConfiguration()).getServices();
        String fixtureClassNamesCsv = this.classNamesFrom(this.getAppManifest().getFixtures());
        this.putConfigurationProperty("isis.fixtures", fixtureClassNamesCsv);
        this.authenticationManager = authenticationManager;
        this.authorizationManager = authorizationManager;
    }

    public AppManifest getAppManifest() {
        return this.appManifest;
    }

    public IsisConfigurationDefault getConfiguration() {
        return this.configuration;
    }

    private void putAppManifestKey(AppManifest appManifest) {
        this.putConfigurationProperty("isis.appManifest", appManifest.getClass().getName());
    }

    private void findAndRegisterTypes(AppManifest appManifest) {
        Iterable<String> modulePackages = this.modulePackageNamesFrom(appManifest);
        AppManifest.Registry registry = AppManifest.Registry.instance();
        ArrayList moduleAndFrameworkPackages = Lists.newArrayList();
        moduleAndFrameworkPackages.addAll(AppManifest.Registry.FRAMEWORK_PROVIDED_SERVICES);
        Iterables.addAll((Collection)moduleAndFrameworkPackages, modulePackages);
        Vfs.setDefaultURLTypes((List)ClassDiscoveryServiceUsingReflections.getUrlTypes());
        Reflections reflections = new Reflections(new Object[]{moduleAndFrameworkPackages});
        LinkedHashSet domainServiceTypes = Sets.newLinkedHashSet();
        domainServiceTypes.addAll(reflections.getTypesAnnotatedWith(DomainService.class));
        domainServiceTypes.addAll(reflections.getTypesAnnotatedWith(DomainServiceLayout.class));
        LinkedHashSet persistenceCapableTypes = Sets.newLinkedHashSet();
        persistenceCapableTypes.addAll(reflections.getTypesAnnotatedWith(PersistenceCapable.class));
        LinkedHashSet fixtureScriptTypes = Sets.newLinkedHashSet();
        fixtureScriptTypes.addAll(FluentIterable.from((Iterable)reflections.getSubTypesOf(FixtureScript.class)).filter(new Predicate<Class<?>>(){

            public boolean apply(@Nullable Class<?> aClass) {
                return DiscoverableFixtureScript.class.isAssignableFrom(aClass) || Annotations.getAnnotation(aClass, Programmatic.class) == null;
            }
        }).toList());
        LinkedHashSet domainObjectTypes = Sets.newLinkedHashSet();
        domainObjectTypes.addAll(reflections.getTypesAnnotatedWith(DomainObject.class));
        domainObjectTypes.addAll(reflections.getTypesAnnotatedWith(DomainObjectLayout.class));
        HashSet mixinTypes = Sets.newHashSet();
        mixinTypes.addAll(reflections.getTypesAnnotatedWith(Mixin.class));
        mixinTypes.addAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)domainObjectTypes, (Predicate)new Predicate<Class<?>>(){

            public boolean apply(@Nullable Class<?> input) {
                if (input == null) {
                    return false;
                }
                DomainObject annotation = input.getAnnotation(DomainObject.class);
                return annotation != null && annotation.nature() == Nature.MIXIN;
            }
        })));
        LinkedHashSet viewModelTypes = Sets.newLinkedHashSet();
        viewModelTypes.addAll(reflections.getTypesAnnotatedWith(ViewModel.class));
        viewModelTypes.addAll(reflections.getTypesAnnotatedWith(ViewModelLayout.class));
        LinkedHashSet xmlElementTypes = Sets.newLinkedHashSet();
        xmlElementTypes.addAll(reflections.getTypesAnnotatedWith(XmlElement.class));
        domainServiceTypes.addAll(appManifest.getAdditionalServices());
        ImmutableList packagesWithDotSuffix = FluentIterable.from((Iterable)moduleAndFrameworkPackages).transform((Function)new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String s) {
                return s != null ? s + "." : null;
            }
        }).toList();
        registry.setDomainServiceTypes(IsisComponentProvider.withinPackageAndNotAnonymous((List<String>)packagesWithDotSuffix, domainServiceTypes));
        registry.setPersistenceCapableTypes(IsisComponentProvider.withinPackageAndNotAnonymous((List<String>)packagesWithDotSuffix, persistenceCapableTypes));
        registry.setFixtureScriptTypes(IsisComponentProvider.withinPackageAndNotAnonymous((List<String>)packagesWithDotSuffix, fixtureScriptTypes));
        registry.setMixinTypes(IsisComponentProvider.withinPackageAndNotAnonymous((List<String>)packagesWithDotSuffix, mixinTypes));
        registry.setDomainObjectTypes(IsisComponentProvider.withinPackageAndNotAnonymous((List<String>)packagesWithDotSuffix, domainObjectTypes));
        registry.setViewModelTypes(IsisComponentProvider.withinPackageAndNotAnonymous((List<String>)packagesWithDotSuffix, viewModelTypes));
        registry.setXmlElementTypes(IsisComponentProvider.withinPackageAndNotAnonymous((List<String>)packagesWithDotSuffix, xmlElementTypes));
    }

    static <T> Set<Class<? extends T>> withinPackageAndNotAnonymous(List<String> packagesWithDotSuffix, Set<Class<? extends T>> classes) {
        LinkedHashSet classesWithin = Sets.newLinkedHashSet();
        for (Class<T> clz : classes) {
            String className = clz.getName();
            if (!IsisComponentProvider.containedWithin(packagesWithDotSuffix, className) || !IsisComponentProvider.notAnonymous(clz)) continue;
            classesWithin.add(clz);
        }
        return classesWithin;
    }

    private static boolean containedWithin(List<String> packagesWithDotSuffix, String className) {
        for (String packageWithDotSuffix : packagesWithDotSuffix) {
            if (!className.startsWith(packageWithDotSuffix)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean notAnonymous(Class<? extends T> clz) {
        try {
            return !clz.isAnonymousClass();
        }
        catch (NoClassDefFoundError error) {
            return false;
        }
    }

    private void specifyServicesAndRegisteredEntitiesUsing(AppManifest appManifest) {
        Iterable<String> packageNames = this.modulePackageNamesFrom(appManifest);
        String packageNamesCsv = Joiner.on((char)',').join(packageNames);
        this.putConfigurationProperty("isis.services.ServicesInstallerFromAnnotation.packagePrefix", packageNamesCsv);
        this.putConfigurationProperty("isis.persistor.datanucleus.RegisterEntities.packagePrefix", packageNamesCsv);
        List additionalServices = appManifest.getAdditionalServices();
        if (additionalServices != null) {
            String additionalServicesCsv = this.classNamesFrom(additionalServices);
            this.appendToPropertyCsvValue("isis.services", additionalServicesCsv);
        }
    }

    private void appendToPropertyCsvValue(String servicesKey, String additionalServicesCsv) {
        String existingServicesCsv = this.configuration.getString(servicesKey);
        String servicesCsv = IsisComponentProvider.join(existingServicesCsv, additionalServicesCsv);
        this.putConfigurationProperty(servicesKey, servicesCsv);
    }

    private static String join(String csv1, String csv2) {
        if (csv1 == null) {
            return csv2;
        }
        if (csv2 == null) {
            return csv1;
        }
        return Joiner.on((String)",").join((Object)csv1, (Object)csv2, new Object[0]);
    }

    private Iterable<String> modulePackageNamesFrom(AppManifest appManifest) {
        List modules = appManifest.getModules();
        if (modules == null || modules.isEmpty()) {
            throw new IllegalArgumentException("If an appManifest is provided then it must return a non-empty set of modules");
        }
        return Iterables.transform((Iterable)modules, (Function)ClassUtil.Functions.packageNameOf());
    }

    protected String classNamesFrom(List<?> objectsOrClasses) {
        if (objectsOrClasses == null) {
            return null;
        }
        Iterable fixtureClassNames = Iterables.transform(objectsOrClasses, IsisComponentProvider.classNameOf());
        return Joiner.on((char)',').join(fixtureClassNames);
    }

    private static Function<Object, String> classNameOf() {
        return new Function<Object, String>(){

            @Nullable
            public String apply(Object input) {
                Class<?> aClass = input instanceof Class ? (Class<?>)input : input.getClass();
                return aClass.getName();
            }
        };
    }

    private void addToConfigurationUsing(AppManifest appManifest) {
        Map configurationProperties = appManifest.getConfigurationProperties();
        if (configurationProperties != null) {
            for (Map.Entry configProp : configurationProperties.entrySet()) {
                this.addConfigurationProperty((String)configProp.getKey(), (String)configProp.getValue());
            }
        }
    }

    void putConfigurationProperty(String key, String value) {
        if (value == null) {
            return;
        }
        this.configuration.put(key, value);
    }

    void addConfigurationProperty(String key, String value) {
        if (value == null) {
            return;
        }
        this.configuration.add(key, value);
    }

    public AuthenticationManager provideAuthenticationManager() {
        return this.authenticationManager;
    }

    public AuthorizationManager provideAuthorizationManager() {
        return this.authorizationManager;
    }

    public ServicesInjector provideServiceInjector(IsisConfiguration configuration) {
        return new ServicesInjector(this.services, configuration);
    }

    public SpecificationLoader provideSpecificationLoader(ServicesInjector servicesInjector, Collection<MetaModelRefiner> metaModelRefiners) throws IsisSystemException {
        ProgrammingModel programmingModel = this.createProgrammingModel();
        MetaModelValidator mmv = this.createMetaModelValidator();
        List<LayoutMetadataReader> layoutMetadataReaders = this.createLayoutMetadataReaders();
        return JavaReflectorHelper.createObjectReflector((IsisConfiguration)this.configuration, (ProgrammingModel)programmingModel, metaModelRefiners, layoutMetadataReaders, (MetaModelValidator)mmv, (ServicesInjector)servicesInjector);
    }

    protected MetaModelValidator createMetaModelValidator() {
        String metaModelValidatorClassName = this.configuration.getString("isis.reflector.validator", ReflectorConstants.META_MODEL_VALIDATOR_CLASS_NAME_DEFAULT);
        return (MetaModelValidator)InstanceUtil.createInstance((String)metaModelValidatorClassName, MetaModelValidator.class, (Object[])new Object[0]);
    }

    protected ProgrammingModel createProgrammingModel() {
        ProgrammingModelFacetsJava5 programmingModel = new ProgrammingModelFacetsJava5((IsisConfiguration)this.configuration);
        FacetFactorySet.Util.includeFacetFactories((IsisConfiguration)this.configuration, (FacetFactorySet)programmingModel);
        FacetFactorySet.Util.excludeFacetFactories((IsisConfiguration)this.configuration, (FacetFactorySet)programmingModel);
        return programmingModel;
    }

    protected List<LayoutMetadataReader> createLayoutMetadataReaders() {
        ArrayList layoutMetadataReaders = Lists.newArrayList();
        String[] layoutMetadataReaderClassNames = this.configuration.getList("isis.reflector.layoutMetadataReaders", ReflectorConstants.LAYOUT_METADATA_READER_LIST_DEFAULT);
        if (layoutMetadataReaderClassNames != null) {
            for (String layoutMetadataReaderClassName : layoutMetadataReaderClassNames) {
                LayoutMetadataReader layoutMetadataReader = (LayoutMetadataReader)InstanceUtil.createInstance((String)layoutMetadataReaderClassName, LayoutMetadataReader.class, (Object[])new Object[0]);
                layoutMetadataReaders.add(layoutMetadataReader);
            }
        }
        return layoutMetadataReaders;
    }
}

