/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.transaction;

import java.util.UUID;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.iactn.InteractionContext;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManagerException;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosure;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosureWithReturn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisTransactionManager
implements SessionScopedComponent {
    private static final Logger LOG = LoggerFactory.getLogger(IsisTransactionManager.class);
    private int transactionLevel;
    private IsisSession session;
    private IsisTransaction currentTransaction;
    private final PersistenceSession persistenceSession;
    private final AuthenticationSession authenticationSession;
    private final ServicesInjector servicesInjector;
    private final CommandContext commandContext;
    private final InteractionContext interactionContext;

    public IsisTransactionManager(PersistenceSession persistenceSession, AuthenticationSession authenticationSession, ServicesInjector servicesInjector) {
        this.persistenceSession = persistenceSession;
        this.authenticationSession = authenticationSession;
        this.servicesInjector = servicesInjector;
        this.commandContext = (CommandContext)this.servicesInjector.lookupServiceElseFail(CommandContext.class);
        this.interactionContext = (InteractionContext)this.servicesInjector.lookupServiceElseFail(InteractionContext.class);
    }

    public PersistenceSession getPersistenceSession() {
        return this.persistenceSession;
    }

    public void open() {
        assert (this.session != null);
    }

    public void close() {
        if (this.getCurrentTransaction() != null) {
            try {
                this.abortTransaction();
            }
            catch (Exception e2) {
                LOG.error("failure during abort", (Throwable)e2);
            }
        }
        this.session = null;
    }

    public IsisTransaction getCurrentTransaction() {
        return this.currentTransaction;
    }

    public int getTransactionLevel() {
        return this.transactionLevel;
    }

    public void executeWithinTransaction(TransactionalClosure closure) {
        this.executeWithinTransaction(null, closure);
    }

    public void executeWithinTransaction(Command existingCommandIfAny, TransactionalClosure closure) {
        boolean initiallyInTransaction = this.inTransaction();
        if (!initiallyInTransaction) {
            this.startTransaction(existingCommandIfAny);
        }
        try {
            closure.execute();
            if (!initiallyInTransaction) {
                this.endTransaction();
            }
        }
        catch (RuntimeException ex) {
            if (!initiallyInTransaction) {
                try {
                    this.abortTransaction();
                }
                catch (Exception e) {
                    LOG.error("Abort failure after exception", (Throwable)e);
                    throw new IsisTransactionManagerException("Abort failure: " + e.getMessage(), ex);
                }
            } else {
                this.getCurrentTransaction().setAbortCause(new IsisException((Throwable)ex));
            }
            throw ex;
        }
    }

    public <Q> Q executeWithinTransaction(TransactionalClosureWithReturn<Q> closure) {
        return this.executeWithinTransaction(null, closure);
    }

    public <Q> Q executeWithinTransaction(Command existingCommandIfAny, TransactionalClosureWithReturn<Q> closure) {
        boolean initiallyInTransaction = this.inTransaction();
        if (!initiallyInTransaction) {
            this.startTransaction(existingCommandIfAny);
        }
        try {
            Q retVal = closure.execute();
            if (!initiallyInTransaction) {
                this.endTransaction();
            }
            return retVal;
        }
        catch (RuntimeException ex) {
            if (!initiallyInTransaction) {
                this.abortTransaction();
            } else {
                this.getCurrentTransaction().setAbortCause(new IsisException((Throwable)ex));
            }
            throw ex;
        }
    }

    public boolean inTransaction() {
        return this.getCurrentTransaction() != null && !this.getCurrentTransaction().getState().isComplete();
    }

    public void startTransaction() {
        this.startTransaction(null);
    }

    public void startTransaction(Command existingCommandIfAny) {
        boolean noneInProgress = false;
        if (this.getCurrentTransaction() == null || this.getCurrentTransaction().getState().isComplete()) {
            noneInProgress = true;
            Interaction interaction = this.interactionContext.getInteraction();
            if (existingCommandIfAny != null) {
                this.commandContext.setCommand(existingCommandIfAny);
                interaction.setTransactionId(existingCommandIfAny.getTransactionId());
            }
            Command command = this.commandContext.getCommand();
            UUID transactionId = command.getTransactionId();
            this.currentTransaction = new IsisTransaction(transactionId, interaction.next(Interaction.Sequence.TRANSACTION.id()), this.authenticationSession, this.servicesInjector);
            this.transactionLevel = 0;
            this.persistenceSession.startTransaction();
        }
        ++this.transactionLevel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("startTransaction: level {}->{}{}", new Object[]{this.transactionLevel - 1, this.transactionLevel, noneInProgress ? " (no transaction in progress or was previously completed; transaction created)" : ""});
        }
    }

    public boolean flushTransaction() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushTransaction");
        }
        if (this.getCurrentTransaction() != null) {
            this.getCurrentTransaction().flush();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        IsisTransaction transaction = this.getCurrentTransaction();
        if (transaction == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("endTransaction: level {} (no transaction exists)", (Object)this.transactionLevel);
            }
            return;
        }
        if (transaction.getState().isComplete()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("endTransaction: level {} (previous transaction completed)", (Object)this.transactionLevel);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("endTransaction: level {}->{}", (Object)this.transactionLevel, (Object)(this.transactionLevel - 1));
        }
        try {
            this.endTransactionInternal();
        }
        finally {
            IsisTransaction.State state = this.getCurrentTransaction().getState();
            int transactionLevel = this.transactionLevel;
            if (transactionLevel == 0 && !state.isComplete()) {
                LOG.error("endTransaction: inconsistency detected between transactionLevel {} and transactionState '{}'", (Object)transactionLevel, (Object)state);
            }
        }
    }

    private void endTransactionInternal() {
        IsisTransaction transaction = this.getCurrentTransaction();
        Object abortCause = this.getCurrentTransaction().getAbortCause();
        if (transaction.getState().mustAbort()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("endTransaction: aborting instead [EARLY TERMINATION], abort cause '{}' has been set", (Object)abortCause.getMessage());
            }
            try {
                this.abortTransaction();
                abortCause = this.getCurrentTransaction().getAbortCause();
            }
            catch (RuntimeException ex) {
                abortCause = ex;
            }
            if (abortCause != null) {
                throw abortCause;
            }
            return;
        }
        int nextTransactionLevel = this.transactionLevel - 1;
        if (nextTransactionLevel > 0) {
            --this.transactionLevel;
        } else if (nextTransactionLevel == 0) {
            if (abortCause == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("endTransaction: committing");
                }
                try {
                    this.getCurrentTransaction().preCommit();
                }
                catch (Exception ex) {
                    abortCause = ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
                    this.getCurrentTransaction().setAbortCause(new IsisTransactionManagerException(ex));
                }
            }
            if (abortCause == null) {
                try {
                    this.persistenceSession.endTransaction();
                }
                catch (Exception ex) {
                    abortCause = ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
                    this.getCurrentTransaction().setAbortCause(new IsisTransactionManagerException(ex));
                }
            }
            this.transactionLevel = 0;
            if (abortCause != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("endTransaction: aborting instead, abort cause has been set");
                }
                try {
                    this.abortTransaction();
                }
                catch (RuntimeException ex) {
                    // empty catch block
                }
                throw abortCause;
            }
            this.getCurrentTransaction().commit();
        } else {
            LOG.error("endTransaction: transactionLevel={}", (Object)this.transactionLevel);
            this.transactionLevel = 0;
            IllegalStateException ex = new IllegalStateException(" no transaction running to end (transactionLevel < 0)");
            this.getCurrentTransaction().setAbortCause(new IsisException((Throwable)ex));
            throw ex;
        }
    }

    public void abortTransaction() {
        if (this.getCurrentTransaction() != null) {
            this.getCurrentTransaction().markAsAborted();
            this.transactionLevel = 0;
            this.persistenceSession.abortTransaction();
        }
    }

    public void addCommand(PersistenceCommand command) {
        this.getCurrentTransaction().addCommand(command);
    }
}

