/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.session;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.title.TitleService;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.appmanifest.AppManifestProvider;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.ServiceInitializer;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.fixtures.FixturesInstallerFromConfiguration;
import org.apache.isis.core.runtime.system.MessageRegistry;
import org.apache.isis.core.runtime.system.internal.InitialisationSession;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactoryBuilder;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisSessionFactory
implements ApplicationScopedComponent,
AppManifestProvider {
    private static final Logger LOG = LoggerFactory.getLogger(IsisSessionFactory.class);
    private final DeploymentCategory deploymentCategory;
    private final IsisConfiguration configuration;
    private final SpecificationLoader specificationLoader;
    private final ServicesInjector servicesInjector;
    private final AuthenticationManager authenticationManager;
    private final AuthorizationManager authorizationManager;
    private final PersistenceSessionFactory persistenceSessionFactory;
    private final AppManifest appManifest;
    private ServiceInitializer serviceInitializer;
    private LogonFixture logonFixture;
    private final ThreadLocal<IsisSession> currentSession = new ThreadLocal();

    public IsisSessionFactory(DeploymentCategory deploymentCategory, ServicesInjector servicesInjector, AppManifest appManifest) {
        this.servicesInjector = servicesInjector;
        this.deploymentCategory = deploymentCategory;
        this.configuration = servicesInjector.getConfigurationServiceInternal();
        this.specificationLoader = servicesInjector.getSpecificationLoader();
        this.authenticationManager = servicesInjector.getAuthenticationManager();
        this.authorizationManager = servicesInjector.getAuthorizationManager();
        this.persistenceSessionFactory = (PersistenceSessionFactory)servicesInjector.lookupServiceElseFail(PersistenceSessionFactory.class);
        this.appManifest = appManifest;
    }

    @Programmatic
    public AppManifest getAppManifest() {
        return this.appManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Programmatic
    public void constructServices() {
        this.serviceInitializer = new ServiceInitializer(this.configuration, this.servicesInjector.getRegisteredServices());
        this.serviceInitializer.validate();
        this.openSession((AuthenticationSession)new InitialisationSession());
        try {
            IsisTransactionManager transactionManager = this.getCurrentSessionTransactionManager();
            transactionManager.startTransaction();
            try {
                this.serviceInitializer.postConstruct();
            }
            catch (RuntimeException ex) {
                transactionManager.getCurrentTransaction().setAbortCause(new IsisTransactionManagerException(ex));
            }
            finally {
                transactionManager.endTransaction();
            }
            FixturesInstallerFromConfiguration fixtureInstaller = new FixturesInstallerFromConfiguration(this);
            fixtureInstaller.installFixtures();
            if (!this.deploymentCategory.isProduction()) {
                this.logonFixture = fixtureInstaller.getLogonFixture();
            }
            List services = this.servicesInjector.getRegisteredServices();
            ArrayList copyOfServices = Lists.newArrayList((Iterable)services);
            TitleService titleService = (TitleService)this.servicesInjector.lookupServiceElseFail(TitleService.class);
            for (Object service : copyOfServices) {
                String string = titleService.titleOf(service);
            }
            for (ObjectSpecification objSpec : this.servicesInjector.getSpecificationLoader().allSpecifications()) {
                T[] enumConstants;
                Class correspondingClass = objSpec.getCorrespondingClass();
                if (!correspondingClass.isEnum()) continue;
                for (Object enumConstant : enumConstants = correspondingClass.getEnumConstants()) {
                    String string = titleService.titleOf(enumConstant);
                }
            }
            TranslationService translationService = (TranslationService)this.servicesInjector.lookupServiceElseFail(TranslationService.class);
            String context = IsisSessionFactoryBuilder.class.getName();
            MessageRegistry messageRegistry = new MessageRegistry();
            List<String> messages = messageRegistry.listMessages();
            for (String message : messages) {
                translationService.translate(context, message);
            }
        }
        finally {
            this.closeSession();
        }
    }

    @Programmatic
    public void destroyServicesAndShutdown() {
        this.destroyServices();
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyServices() {
        if (this.serviceInitializer == null) {
            return;
        }
        this.openSession((AuthenticationSession)new InitialisationSession());
        IsisTransactionManager transactionManager = this.getCurrentSessionTransactionManager();
        try {
            transactionManager.startTransaction();
            try {
                this.serviceInitializer.preDestroy();
            }
            catch (RuntimeException ex) {
                transactionManager.getCurrentTransaction().setAbortCause(new IsisTransactionManagerException(ex));
            }
            finally {
                transactionManager.endTransaction();
            }
        }
        finally {
            this.closeSession();
        }
    }

    private void shutdown() {
        this.persistenceSessionFactory.shutdown();
        this.authenticationManager.shutdown();
        this.specificationLoader.shutdown();
    }

    @Programmatic
    public LogonFixture getLogonFixture() {
        return this.logonFixture;
    }

    @Programmatic
    public IsisSession openSession(AuthenticationSession authenticationSession) {
        this.closeSession();
        PersistenceSession persistenceSession = this.persistenceSessionFactory.createPersistenceSession(this.servicesInjector, authenticationSession);
        IsisSession session = new IsisSession(authenticationSession, persistenceSession);
        this.currentSession.set(session);
        session.open();
        return session;
    }

    @Programmatic
    public void closeSession() {
        IsisSession existingSessionIfAny = this.getCurrentSession();
        if (existingSessionIfAny == null) {
            return;
        }
        existingSessionIfAny.close();
        this.currentSession.set(null);
    }

    @Programmatic
    public IsisSession getCurrentSession() {
        return this.currentSession.get();
    }

    private IsisTransactionManager getCurrentSessionTransactionManager() {
        IsisSession currentSession = this.getCurrentSession();
        return currentSession.getPersistenceSession().getTransactionManager();
    }

    @Programmatic
    public boolean inSession() {
        return this.getCurrentSession() != null;
    }

    @Programmatic
    public boolean inTransaction() {
        return this.inSession() && this.getCurrentSession().getCurrentTransaction() != null && !this.getCurrentSession().getCurrentTransaction().getState().isComplete();
    }

    @Programmatic
    public void doInSession(Runnable runnable) {
        this.doInSession(runnable, (AuthenticationSession)new InitialisationSession());
    }

    @Programmatic
    public void doInSession(final Runnable runnable, AuthenticationSession authenticationSession) {
        this.doInSession(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        }, authenticationSession);
    }

    @Programmatic
    public <R> R doInSession(Callable<R> callable) {
        return this.doInSession(callable, (AuthenticationSession)new InitialisationSession());
    }

    @Programmatic
    public <R> R doInSession(Callable<R> callable, AuthenticationSession authenticationSession) {
        IsisSessionFactory sessionFactory = this;
        boolean noSession = !sessionFactory.inSession();
        try {
            if (noSession) {
                sessionFactory.openSession(authenticationSession);
            }
            R r = callable.call();
            return r;
        }
        catch (Exception x) {
            throw new RuntimeException(String.format("An error occurred while executing code in %s session", noSession ? "a temporary" : "a"), x);
        }
        finally {
            if (noSession) {
                sessionFactory.closeSession();
            }
        }
    }

    @Programmatic
    public DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategory;
    }

    @Programmatic
    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    @Programmatic
    public ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }

    @Programmatic
    @Deprecated
    public List<Object> getServices() {
        return this.servicesInjector.getRegisteredServices();
    }

    @Programmatic
    public SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    @Programmatic
    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    @Programmatic
    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    @Programmatic
    public PersistenceSessionFactory getPersistenceSessionFactory() {
        return this.persistenceSessionFactory;
    }
}

