/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.session;

import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisSession
implements SessionScopedComponent {
    private static final Logger LOG = LoggerFactory.getLogger(IsisSession.class);
    private final AuthenticationSession authenticationSession;
    private PersistenceSession persistenceSession;

    public IsisSession(AuthenticationSession authenticationSession, PersistenceSession persistenceSession) {
        this.authenticationSession = authenticationSession;
        this.persistenceSession = persistenceSession;
    }

    void open() {
        this.persistenceSession.open();
    }

    void close() {
        if (this.persistenceSession != null) {
            this.persistenceSession.close();
        }
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    public PersistenceSession getPersistenceSession() {
        return this.persistenceSession;
    }

    public IsisTransaction getCurrentTransaction() {
        return this.getTransactionManager().getCurrentTransaction();
    }

    public String toString() {
        ToString asString = new ToString((Object)this);
        asString.append("authenticationSession", (Object)this.getAuthenticationSession());
        asString.append("persistenceSession", (Object)this.getPersistenceSession());
        asString.append("transaction", (Object)this.getCurrentTransaction());
        return asString.toString();
    }

    private IsisTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }
}

