/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.ParentedCollectionOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;

public class RootAndCollectionAdapters
implements Iterable<ObjectAdapter> {
    private final ObjectAdapter parentAdapter;
    private final RootOid rootAdapterOid;
    private final Map<OneToManyAssociation, ObjectAdapter> collectionAdapters = Maps.newLinkedHashMap();

    public RootAndCollectionAdapters(ObjectAdapter parentAdapter, AdapterManager adapterManager) {
        Assert.assertNotNull((Object)parentAdapter);
        this.rootAdapterOid = (RootOid)parentAdapter.getOid();
        this.parentAdapter = parentAdapter;
        this.addCollectionAdapters(adapterManager);
    }

    public ObjectAdapter getRootAdapter() {
        return this.parentAdapter;
    }

    @Override
    public Iterator<ObjectAdapter> iterator() {
        return this.getCollectionAdapters().values().iterator();
    }

    public Set<OneToManyAssociation> getCollections() {
        return this.getCollectionAdapters().keySet();
    }

    public ObjectAdapter getCollectionAdapter(OneToManyAssociation otma) {
        return this.collectionAdapters.get(otma);
    }

    private void addCollectionAdapters(AdapterManager objectAdapterLookup) {
        for (OneToManyAssociation otma : this.parentAdapter.getSpecification().getCollections(Contributed.EXCLUDED)) {
            ParentedCollectionOid collectionOid = new ParentedCollectionOid(this.rootAdapterOid, otma);
            ObjectAdapter collectionAdapter = objectAdapterLookup.getAdapterFor((Oid)collectionOid);
            if (collectionAdapter == null) continue;
            this.addCollectionAdapter(otma, collectionAdapter);
        }
    }

    private void addCollectionAdapter(OneToManyAssociation otma, ObjectAdapter collectionAdapter) {
        Assert.assertNotNull((Object)otma);
        Assert.assertNotNull((Object)collectionAdapter);
        this.collectionAdapters.put(otma, collectionAdapter);
    }

    private Map<OneToManyAssociation, ObjectAdapter> getCollectionAdapters() {
        return Collections.unmodifiableMap(this.collectionAdapters);
    }
}

