/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoAdapterHashMap
implements Iterable<ObjectAdapter>,
SessionScopedComponent {
    private static final Logger LOG = LoggerFactory.getLogger(PojoAdapterHashMap.class);
    public static final int DEFAULT_POJO_ADAPTER_MAP_SIZE = 100;
    protected final Map<Object, ObjectAdapter> adapterByPojoMap;

    public PojoAdapterHashMap() {
        this(100);
    }

    public PojoAdapterHashMap(int capacity) {
        this.adapterByPojoMap = Maps.newHashMapWithExpectedSize((int)capacity);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("finalizing hash of pojos");
        }
    }

    public void open() {
    }

    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("close");
        }
        this.adapterByPojoMap.clear();
    }

    public void add(Object pojo, ObjectAdapter adapter) {
        this.adapterByPojoMap.put(this.key(pojo), adapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("add adapter: #{} -> #{}", this.key(pojo), (Object)Long.toHexString(adapter.hashCode()));
        }
    }

    public void remove(ObjectAdapter object) {
        LOG.debug("remove adapter: {}", (Object)object);
        this.adapterByPojoMap.remove(this.key(object.getObject()));
    }

    public boolean containsPojo(Object pojo) {
        return this.adapterByPojoMap.containsKey(this.key(pojo));
    }

    public ObjectAdapter getAdapter(Object pojo) {
        return this.adapterByPojoMap.get(this.key(pojo));
    }

    @Override
    public Iterator<ObjectAdapter> iterator() {
        return this.adapterByPojoMap.values().iterator();
    }

    private Object key(Object pojo) {
        return new IdentityHashKey(pojo);
    }

    private static class IdentityHashKey {
        private final Object pojo;

        public IdentityHashKey(Object pojo) {
            this.pojo = pojo;
        }

        public int hashCode() {
            return System.identityHashCode(this.pojo);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof IdentityHashKey && ((IdentityHashKey)obj).pojo == this.pojo;
        }
    }
}

