/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidAdapterHashMap
implements Iterable<Oid>,
SessionScopedComponent {
    private static final Logger LOG = LoggerFactory.getLogger(OidAdapterHashMap.class);
    public static final int DEFAULT_OID_ADAPTER_MAP_SIZE = 100;
    private final Map<Oid, ObjectAdapter> adapterByOidMap = Maps.newHashMapWithExpectedSize((int)100);

    public void open() {
    }

    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("close");
        }
        this.adapterByOidMap.clear();
    }

    public void add(Oid oid, ObjectAdapter adapter) {
        this.adapterByOidMap.put(oid, adapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("add oid: {} ; oid.hashCode: + #{} ; adapter.hashCode(): #{}", new Object[]{oid, Long.toHexString(oid.hashCode()), Long.toHexString(adapter.hashCode())});
        }
    }

    public boolean remove(Oid oid) {
        LOG.debug("remove oid: {}", (Object)oid);
        return this.adapterByOidMap.remove(oid) != null;
    }

    public ObjectAdapter getAdapter(Oid oid) {
        return this.adapterByOidMap.get(oid);
    }

    @Override
    public Iterator<Oid> iterator() {
        return this.adapterByOidMap.keySet().iterator();
    }
}

