/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jdo.FetchPlan;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.listener.InstanceLifecycleListener;
import org.apache.isis.applib.annotation.Bulk;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService2;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.Command2;
import org.apache.isis.applib.services.command.Command3;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.command.spi.CommandService;
import org.apache.isis.applib.services.eventbus.AbstractLifecycleEvent;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer2;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.iactn.InteractionContext;
import org.apache.isis.applib.services.metrics.MetricsService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.ensure.IsisAssertException;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.ParentedCollectionOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.ElementSpecificationProviderFromTypeOfFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.CreatedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.CreatedLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.LifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadedLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatedLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatingLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.spec.FreeStandingList;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.persistence.FixturesInstalledFlag;
import org.apache.isis.core.runtime.persistence.NotPersistableException;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.core.runtime.persistence.PojoRecreationException;
import org.apache.isis.core.runtime.persistence.PojoRefreshException;
import org.apache.isis.core.runtime.persistence.UnsupportedFindException;
import org.apache.isis.core.runtime.persistence.adapter.PojoAdapter;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.TransactionalResource;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindAllInstances;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindUsingApplibQueryDefault;
import org.apache.isis.core.runtime.services.RequestScopedService;
import org.apache.isis.core.runtime.services.changes.ChangedObjectsServiceInternal;
import org.apache.isis.core.runtime.system.persistence.IsisLifecycleListener2;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.core.runtime.system.persistence.PersistenceQueryFactory;
import org.apache.isis.core.runtime.system.persistence.Utils;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.OidAdapterHashMap;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.PojoAdapterHashMap;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.RootAndCollectionAdapters;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosure;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosureWithReturn;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.commands.DataNucleusCreateObjectCommand;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.commands.DataNucleusDeleteObjectCommand;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryFindAllInstancesProcessor;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryFindUsingApplibQueryProcessor;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryProcessor;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.spi.JdoObjectIdSerializer;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.DatastoreIdImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceSession
implements TransactionalResource,
SessionScopedComponent,
AdapterManager,
IsisLifecycleListener2.PersistenceSessionLifecycleManagement {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceSession.class);
    public static final String INSTALL_FIXTURES_KEY = "isis.persistor.datanucleus.install-fixtures";
    public static final boolean INSTALL_FIXTURES_DEFAULT = false;
    private static final String ROOT_KEY = "isis.persistor.datanucleus.";
    public static final String DATANUCLEUS_PROPERTIES_ROOT = "isis.persistor.datanucleus.impl.";
    public static final String SERVICE_IDENTIFIER = "1";
    private final FixturesInstalledFlag fixturesInstalledFlag;
    private final PersistenceQueryFactory persistenceQueryFactory;
    private final IsisConfiguration configuration;
    private final SpecificationLoader specificationLoader;
    private final AuthenticationSession authenticationSession;
    private final ServicesInjector servicesInjector;
    private final CommandContext commandContext;
    private final CommandService commandService;
    private final InteractionContext interactionContext;
    private final EventBusService eventBusService;
    private final ChangedObjectsServiceInternal changedObjectsServiceInternal;
    private final FactoryService factoryService;
    private final MetricsService metricsService;
    private final ClockService clockService;
    private final UserService userService;
    private final Bulk.InteractionContext bulkInteractionContext;
    private final PersistenceManagerFactory jdoPersistenceManagerFactory;
    private IsisTransactionManager transactionManager;
    private PersistenceManager persistenceManager;
    private final Map<Class<?>, PersistenceQueryProcessor<?>> persistenceQueryProcessorByClass = Maps.newHashMap();
    private final boolean concurrencyCheckingGloballyEnabled;
    private State state;
    private Map<Oid, Oid> persistentByTransient = Maps.newHashMap();
    private final PojoAdapterHashMap pojoAdapterMap = new PojoAdapterHashMap();
    private final OidAdapterHashMap oidAdapterMap = new OidAdapterHashMap();

    public PersistenceSession(ServicesInjector servicesInjector, AuthenticationSession authenticationSession, PersistenceManagerFactory jdoPersistenceManagerFactory, FixturesInstalledFlag fixturesInstalledFlag) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating {}", (Object)this);
        }
        this.servicesInjector = servicesInjector;
        this.jdoPersistenceManagerFactory = jdoPersistenceManagerFactory;
        this.fixturesInstalledFlag = fixturesInstalledFlag;
        this.configuration = servicesInjector.getConfigurationServiceInternal();
        this.specificationLoader = servicesInjector.getSpecificationLoader();
        this.authenticationSession = authenticationSession;
        this.commandContext = this.lookupService(CommandContext.class);
        this.commandService = this.lookupService(CommandService.class);
        this.interactionContext = this.lookupService(InteractionContext.class);
        this.eventBusService = this.lookupService(EventBusService.class);
        this.changedObjectsServiceInternal = this.lookupService(ChangedObjectsServiceInternal.class);
        this.metricsService = this.lookupService(MetricsService.class);
        this.factoryService = this.lookupService(FactoryService.class);
        this.clockService = this.lookupService(ClockService.class);
        this.userService = this.lookupService(UserService.class);
        this.bulkInteractionContext = this.lookupService(Bulk.InteractionContext.class);
        PersistenceSession adapterManager = this;
        this.persistenceQueryFactory = new PersistenceQueryFactory(adapterManager, this.specificationLoader);
        this.transactionManager = new IsisTransactionManager(this, authenticationSession, servicesInjector);
        this.state = State.NOT_INITIALIZED;
        boolean concurrencyCheckingGloballyDisabled = this.configuration.getBoolean("isis.persistor.disableConcurrencyChecking", false);
        this.concurrencyCheckingGloballyEnabled = !concurrencyCheckingGloballyDisabled;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.debug("finalizing persistence session");
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public void open() {
        this.ensureNotOpened();
        if (LOG.isDebugEnabled()) {
            LOG.debug("opening {}", (Object)this);
        }
        this.oidAdapterMap.open();
        this.pojoAdapterMap.open();
        this.persistenceManager = this.jdoPersistenceManagerFactory.getPersistenceManager();
        PersistenceSession psLifecycleMgmt = this;
        IsisLifecycleListener2 isisLifecycleListener = new IsisLifecycleListener2(psLifecycleMgmt);
        this.persistenceManager.addInstanceLifecycleListener((InstanceLifecycleListener)isisLifecycleListener, (Class[])null);
        this.persistenceQueryProcessorByClass.put(PersistenceQueryFindAllInstances.class, new PersistenceQueryFindAllInstancesProcessor(this));
        this.persistenceQueryProcessorByClass.put(PersistenceQueryFindUsingApplibQueryDefault.class, new PersistenceQueryFindUsingApplibQueryProcessor(this));
        this.initServices();
        this.startRequestOnRequestScopedServices();
        this.postConstructOnRequestScopedServices();
        if (this.metricsService instanceof InstanceLifecycleListener) {
            InstanceLifecycleListener metricsService = (InstanceLifecycleListener)this.metricsService;
            this.persistenceManager.addInstanceLifecycleListener(metricsService, (Class[])null);
        }
        Command command = this.createCommand();
        UUID transactionId = UUID.randomUUID();
        Interaction interaction = (Interaction)this.factoryService.instantiate(Interaction.class);
        Timestamp timestamp = this.clockService.nowAsJavaSqlTimestamp();
        String userName = this.userService.getUser().getName();
        command.setTimestamp(timestamp);
        command.setUser(userName);
        command.setTransactionId(transactionId);
        interaction.setTransactionId(transactionId);
        this.commandContext.setCommand(command);
        this.interactionContext.setInteraction(interaction);
        Bulk.InteractionContext.current.set(this.bulkInteractionContext);
        this.state = State.OPEN;
    }

    private void postConstructOnRequestScopedServices() {
        for (Object service : this.servicesInjector.getRegisteredServices()) {
            if (!(service instanceof RequestScopedService)) continue;
            ((RequestScopedService)service).__isis_postConstruct();
        }
    }

    private void startRequestOnRequestScopedServices() {
        for (Object service : this.servicesInjector.getRegisteredServices()) {
            if (!(service instanceof RequestScopedService)) continue;
            ((RequestScopedService)service).__isis_startRequest(this.servicesInjector);
        }
    }

    private void initServices() {
        List registeredServices = this.servicesInjector.getRegisteredServices();
        for (Object service : registeredServices) {
            ObjectAdapter serviceAdapter = this.adapterFor(service);
            this.remapAsPersistentIfRequired(serviceAdapter);
        }
    }

    private void remapAsPersistentIfRequired(ObjectAdapter serviceAdapter) {
        if (serviceAdapter.getOid().isTransient()) {
            this.remapAsPersistent(serviceAdapter, null);
        }
    }

    private Command createCommand() {
        Command command = this.commandService.create();
        this.servicesInjector.injectServicesInto((Object)command);
        return command;
    }

    public void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        this.completeCommandFromInteractionAndClearDomainEvents();
        this.transactionManager.flushTransaction();
        try {
            IsisTransaction currentTransaction = this.transactionManager.getCurrentTransaction();
            if (currentTransaction != null && !currentTransaction.getState().isComplete()) {
                if (currentTransaction.getState().canCommit()) {
                    this.transactionManager.endTransaction();
                } else if (currentTransaction.getState().canAbort()) {
                    this.transactionManager.abortTransaction();
                }
            }
        }
        catch (Throwable ex) {
            LOG.error("close: failed to end transaction; continuing to avoid memory leakage");
        }
        Bulk.InteractionContext.current.set(null);
        this.preDestroyOnRequestScopedServices();
        this.endRequestOnRequestScopeServices();
        try {
            this.persistenceManager.close();
        }
        catch (Throwable ex) {
            LOG.error("close: failed to close JDO persistenceManager; continuing to avoid memory leakage");
        }
        try {
            this.oidAdapterMap.close();
        }
        catch (Throwable ex) {
            LOG.error("close: oidAdapterMap#close() failed; continuing to avoid memory leakage");
        }
        try {
            this.pojoAdapterMap.close();
        }
        catch (Throwable ex) {
            LOG.error("close: pojoAdapterMap#close() failed; continuing to avoid memory leakage");
        }
        this.state = State.CLOSED;
    }

    private void endRequestOnRequestScopeServices() {
        for (Object service : this.servicesInjector.getRegisteredServices()) {
            if (!(service instanceof RequestScopedService)) continue;
            ((RequestScopedService)service).__isis_endRequest();
        }
    }

    private void preDestroyOnRequestScopedServices() {
        for (Object service : this.servicesInjector.getRegisteredServices()) {
            if (!(service instanceof RequestScopedService)) continue;
            ((RequestScopedService)service).__isis_preDestroy();
        }
    }

    private void completeCommandFromInteractionAndClearDomainEvents() {
        Command command = this.commandContext.getCommand();
        Interaction interaction = this.interactionContext.getInteraction();
        if (command.getStartedAt() != null && command.getCompletedAt() == null) {
            Interaction.Execution priorExecution = interaction.getPriorExecution();
            Timestamp completedAt = priorExecution != null ? priorExecution.getCompletedAt() : this.clockService.nowAsJavaSqlTimestamp();
            command.setCompletedAt(completedAt);
        }
        if (command.getMemberIdentifier() != null && this.metricsService.numberObjectsDirtied() > 0) {
            command.setPersistHint(true);
        }
        this.commandService.complete(command);
        if (command instanceof Command3) {
            Command3 command3 = (Command3)command;
            command3.flushActionDomainEvents();
        } else if (command instanceof Command2) {
            Command2 command2 = (Command2)command;
            command2.flushActionInteractionEvents();
        }
        interaction.clear();
    }

    public <T> List<ObjectAdapter> allMatchingQuery(Query<T> query) {
        ObjectAdapter instances = this.findInstancesInTransaction(query, QueryCardinality.MULTIPLE);
        return CollectionFacetUtils.convertToAdapterList((ObjectAdapter)instances);
    }

    public <T> ObjectAdapter firstMatchingQuery(Query<T> query) {
        ObjectAdapter instances = this.findInstancesInTransaction(query, QueryCardinality.SINGLE);
        List list = CollectionFacetUtils.convertToAdapterList((ObjectAdapter)instances);
        return list.size() > 0 ? (ObjectAdapter)list.get(0) : null;
    }

    private <T> ObjectAdapter findInstancesInTransaction(Query<T> query, QueryCardinality cardinality) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("findInstances using (applib) Query: {}", query);
        }
        final PersistenceQuery persistenceQuery = this.createPersistenceQueryFor(query, cardinality);
        if (LOG.isDebugEnabled()) {
            LOG.debug("maps to (core runtime) PersistenceQuery: {}", (Object)persistenceQuery);
        }
        final PersistenceQueryProcessor<? extends PersistenceQuery> processor = this.lookupProcessorFor(persistenceQuery);
        List<ObjectAdapter> instances = this.transactionManager.executeWithinTransaction(new TransactionalClosureWithReturn<List<ObjectAdapter>>(){

            @Override
            public List<ObjectAdapter> execute() {
                return PersistenceSession.this.processPersistenceQuery(processor, persistenceQuery);
            }
        });
        ObjectSpecification specification = persistenceQuery.getSpecification();
        FreeStandingList results = new FreeStandingList(specification, instances);
        return this.adapterFor(results);
    }

    private final PersistenceQuery createPersistenceQueryFor(Query<?> query, QueryCardinality cardinality) {
        PersistenceQuery persistenceQuery = this.persistenceQueryFactory.createPersistenceQueryFor(query, cardinality);
        if (persistenceQuery == null) {
            throw new IllegalArgumentException("Unknown Query type: " + query.getDescription());
        }
        return persistenceQuery;
    }

    private PersistenceQueryProcessor<? extends PersistenceQuery> lookupProcessorFor(PersistenceQuery persistenceQuery) {
        Class<?> persistenceQueryClass = persistenceQuery.getClass();
        PersistenceQueryProcessor<?> processor = this.persistenceQueryProcessorByClass.get(persistenceQueryClass);
        if (processor == null) {
            throw new UnsupportedFindException(MessageFormat.format("Unsupported PersistenceQuery class: {0}", persistenceQueryClass.getName()));
        }
        return processor;
    }

    private <Q extends PersistenceQuery> List<ObjectAdapter> processPersistenceQuery(PersistenceQueryProcessor<Q> persistenceQueryProcessor, PersistenceQuery persistenceQuery) {
        return persistenceQueryProcessor.process(persistenceQuery);
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void ensureNotOpened() {
        if (this.state != State.NOT_INITIALIZED) {
            throw new IllegalStateException("Persistence session has already been initialized");
        }
    }

    public void ensureOpened() {
        this.ensureStateIs(State.OPEN);
    }

    private void ensureStateIs(State stateRequired) {
        if (this.state == stateRequired) {
            return;
        }
        throw new IllegalStateException("State is: " + (Object)((Object)this.state) + "; should be: " + (Object)((Object)stateRequired));
    }

    public ObjectAdapter createTransientInstance(ObjectSpecification objectSpec) {
        return this.createInstance(objectSpec, Variant.TRANSIENT, null);
    }

    public ObjectAdapter createViewModelInstance(ObjectSpecification objectSpec, String memento) {
        return this.createInstance(objectSpec, Variant.VIEW_MODEL, memento);
    }

    private ObjectAdapter createInstance(ObjectSpecification spec, Variant variant, String memento) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating {} instance of {}", (Object)variant, (Object)spec);
        }
        Object pojo = variant == Variant.VIEW_MODEL ? this.recreateViewModel(spec, memento) : this.instantiateAndInjectServices(spec);
        ObjectAdapter adapter = this.adapterFor(pojo);
        return this.initializePropertiesAndDoCallback(adapter);
    }

    private Object recreateViewModel(ObjectSpecification spec, String memento) {
        Object viewModelPojo;
        ViewModelFacet facet = (ViewModelFacet)spec.getFacet(ViewModelFacet.class);
        if (facet == null) {
            throw new IllegalArgumentException("spec does not have ViewModelFacet; spec is " + spec.getFullIdentifier());
        }
        if (facet.getRecreationMechanism().isInitializes()) {
            viewModelPojo = this.instantiateAndInjectServices(spec);
            facet.initialize(viewModelPojo, memento);
        } else {
            viewModelPojo = facet.instantiate(spec.getCorrespondingClass(), memento);
        }
        return viewModelPojo;
    }

    public Object instantiateAndInjectServices(ObjectSpecification objectSpec) {
        Object newInstance;
        Class correspondingClass = objectSpec.getCorrespondingClass();
        if (correspondingClass.isArray()) {
            return Array.newInstance(correspondingClass.getComponentType(), 0);
        }
        Class cls = correspondingClass;
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new IsisException("Cannot create an instance of an abstract class: " + cls);
        }
        try {
            newInstance = cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IsisException("Failed to create instance of type " + objectSpec.getFullIdentifier(), (Throwable)e);
        }
        this.servicesInjector.injectServicesInto(newInstance);
        return newInstance;
    }

    private ObjectAdapter initializePropertiesAndDoCallback(ObjectAdapter adapter) {
        List fields = adapter.getSpecification().getAssociations(Contributed.EXCLUDED);
        for (ObjectAssociation field : fields) {
            field.toDefault(adapter);
        }
        Object pojo = adapter.getObject();
        this.servicesInjector.injectServicesInto(pojo);
        CallbackFacet.Util.callCallback((ObjectAdapter)adapter, CreatedCallbackFacet.class);
        if (Command.class.isAssignableFrom(pojo.getClass())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping postEvent for creation of Command pojo");
            }
        } else {
            this.postLifecycleEventIfRequired(adapter, CreatedLifecycleEventFacet.class);
        }
        return adapter;
    }

    public List<ObjectAdapter> getServices() {
        List services = this.servicesInjector.getRegisteredServices();
        ArrayList serviceAdapters = Lists.newArrayList();
        for (Object servicePojo : services) {
            ObjectAdapter serviceAdapter = this.getAdapterFor(servicePojo);
            if (serviceAdapter == null) {
                throw new IllegalStateException("ObjectAdapter for service " + servicePojo + " does not exist?!?");
            }
            serviceAdapters.add(serviceAdapter);
        }
        return serviceAdapters;
    }

    void postLifecycleEventIfRequired(ObjectAdapter adapter, Class<? extends LifecycleEventFacet> lifecycleEventFacetClass) {
        LifecycleEventFacet facet = (LifecycleEventFacet)adapter.getSpecification().getFacet(lifecycleEventFacetClass);
        if (facet != null) {
            Class eventType = facet.getEventType();
            Object instance = InstanceUtil.createInstance((Class)eventType, (Object[])new Object[0]);
            Object pojo = adapter.getObject();
            this.postEvent((AbstractLifecycleEvent<Object>)((AbstractLifecycleEvent)instance), pojo);
        }
    }

    void postEvent(AbstractLifecycleEvent<Object> event, Object pojo) {
        event.setSource(pojo);
        this.eventBusService.post(event);
    }

    public boolean isFixturesInstalled() {
        if (this.fixturesInstalledFlag.isFixturesInstalled() == null) {
            this.fixturesInstalledFlag.setFixturesInstalled(this.objectStoreIsFixturesInstalled());
        }
        return this.fixturesInstalledFlag.isFixturesInstalled();
    }

    public boolean objectStoreIsFixturesInstalled() {
        boolean installFixtures = this.configuration.getBoolean(INSTALL_FIXTURES_KEY, false);
        LOG.info("isFixturesInstalled: {} = {}", (Object)INSTALL_FIXTURES_KEY, (Object)installFixtures);
        return !installFixtures;
    }

    public ObjectAdapter loadObjectInTransaction(final RootOid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ObjectAdapter adapter = this.getAdapterFor((Oid)oid);
        if (adapter != null) {
            return adapter;
        }
        return this.transactionManager.executeWithinTransaction(new TransactionalClosureWithReturn<ObjectAdapter>(){

            @Override
            public ObjectAdapter execute() {
                LOG.debug("getObject; oid={}", (Object)oid);
                Object pojo = PersistenceSession.this.loadPersistentPojo(oid);
                return PersistenceSession.this.mapRecreatedPojo((Oid)oid, pojo);
            }
        });
    }

    private Object loadPersistentPojo(RootOid rootOid) {
        Object result;
        try {
            Class<?> cls = this.clsOf(rootOid);
            Object jdoObjectId = JdoObjectIdSerializer.toJdoObjectId(rootOid);
            FetchPlan fetchPlan = this.persistenceManager.getFetchPlan();
            fetchPlan.addGroup("default");
            result = this.persistenceManager.getObjectById(cls, jdoObjectId);
        }
        catch (RuntimeException e) {
            Class<ExceptionRecognizer> serviceClass = ExceptionRecognizer.class;
            List<ExceptionRecognizer> exceptionRecognizers = this.lookupServices(serviceClass);
            for (ExceptionRecognizer exceptionRecognizer : exceptionRecognizers) {
                ExceptionRecognizer2 recognizer;
                ExceptionRecognizer2.Recognition recognition;
                if (!(exceptionRecognizer instanceof ExceptionRecognizer2) || (recognition = (recognizer = (ExceptionRecognizer2)exceptionRecognizer).recognize2((Throwable)e)) == null || recognition.getCategory() != ExceptionRecognizer2.Category.NOT_FOUND) continue;
                throw new ObjectNotFoundException((Oid)rootOid, (Throwable)e);
            }
            throw e;
        }
        if (result == null) {
            throw new ObjectNotFoundException((Oid)rootOid);
        }
        return result;
    }

    private Map<RootOid, Object> loadPersistentPojos(List<RootOid> rootOids) {
        if (rootOids.isEmpty()) {
            return PersistenceSession.zip(rootOids, Collections.emptyList());
        }
        ArrayList dnOids = Lists.newArrayList();
        for (RootOid rootOid : rootOids) {
            DatastoreIdImpl datastoreId;
            Object id = JdoObjectIdSerializer.toJdoObjectId(rootOid);
            if (id instanceof SingleFieldIdentity) {
                dnOids.add(id);
                continue;
            }
            if (id instanceof String && ((String)id).contains("[OID]")) {
                datastoreId = new DatastoreIdImpl((String)id);
                dnOids.add(datastoreId);
                continue;
            }
            datastoreId = new DatastoreIdImpl(this.clsOf(rootOid).getName(), id);
            dnOids.add(datastoreId);
        }
        FetchPlan fetchPlan = this.persistenceManager.getFetchPlan();
        fetchPlan.addGroup("default");
        ArrayList persistentPojos = Lists.newArrayList();
        try {
            Collection pojos = this.persistenceManager.getObjectsById((Collection)dnOids, true);
            for (Object pojo : pojos) {
                try {
                    persistentPojos.add(pojo);
                }
                catch (Exception ex) {
                    persistentPojos.add(null);
                }
            }
        }
        catch (NucleusObjectNotFoundException nonfe) {
            for (Object dnOid : dnOids) {
                try {
                    Object persistentPojo = this.persistenceManager.getObjectById(dnOid);
                    persistentPojos.add(persistentPojo);
                }
                catch (Exception ex) {
                    persistentPojos.add(null);
                }
            }
        }
        Map<RootOid, Object> pojoByOid = PersistenceSession.zip(rootOids, persistentPojos);
        return pojoByOid;
    }

    private static Map<RootOid, Object> zip(List<RootOid> rootOids, Collection<Object> pojos) {
        LinkedHashMap pojoByOid = Maps.newLinkedHashMap();
        int i = 0;
        for (Object pojo : pojos) {
            RootOid rootOid = rootOids.get(i++);
            pojoByOid.put(rootOid, pojo);
        }
        return pojoByOid;
    }

    private Class<?> clsOf(RootOid oid) {
        ObjectSpecification objectSpec = this.getSpecificationLoader().lookupBySpecId(oid.getObjectSpecId());
        return objectSpec.getCorrespondingClass();
    }

    public ObjectAdapter mapPersistent(Persistable pojo) {
        if (this.persistenceManager.getObjectId((Object)pojo) == null) {
            return null;
        }
        RootOid oid = this.createPersistentOrViewModelOid(pojo);
        ObjectAdapter adapter = this.mapRecreatedPojo((Oid)oid, pojo);
        return adapter;
    }

    public void refreshRootInTransaction(final ObjectAdapter adapter) {
        Assert.assertTrue((String)"only resolve object that is persistent", (Object)adapter, (boolean)adapter.representsPersistent());
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosure(){

            public void execute() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("resolveImmediately; oid={}", (Object)adapter.getOid().enString());
                }
                if (!adapter.representsPersistent()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("; not persistent - ignoring");
                    }
                    return;
                }
                PersistenceSession.this.refreshRoot(adapter);
            }
        });
    }

    public void refreshRoot(ObjectAdapter adapter) {
        Object domainObject = adapter.getObject();
        if (domainObject == null) {
            throw new PojoRefreshException(adapter.getOid());
        }
        try {
            this.persistenceManager.refresh(domainObject);
        }
        catch (RuntimeException e) {
            throw new PojoRefreshException(adapter.getOid(), (Throwable)e);
        }
        this.initializeMapAndCheckConcurrency((Persistable)domainObject);
    }

    public void resolve(Object parent) {
        ObjectAdapter adapter = this.adapterFor(parent);
        this.refreshRootInTransaction(adapter);
    }

    public void makePersistentInTransaction(final ObjectAdapter adapter) {
        if (adapter.representsPersistent()) {
            throw new NotPersistableException("Object already persistent: " + adapter);
        }
        if (!adapter.getSpecification().persistability().isPersistable()) {
            throw new NotPersistableException("Object is not persistable: " + adapter);
        }
        ObjectSpecification specification = adapter.getSpecification();
        if (specification.isService()) {
            throw new NotPersistableException("Cannot persist services: " + adapter);
        }
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosure(){

            public void execute() {
                PersistenceSession.this.makePersistentTransactionAssumed(adapter);
                PersistenceSession.this.persistentByTransient.clear();
            }
        });
    }

    private void makePersistentTransactionAssumed(ObjectAdapter adapter) {
        if (PersistenceSession.alreadyPersistedOrNotPersistable(adapter)) {
            return;
        }
        LOG.debug("persist {}", (Object)adapter);
        if (PersistenceSession.alreadyPersistedOrNotPersistable(adapter)) {
            return;
        }
        this.addCreateObjectCommand(adapter);
    }

    private void addCreateObjectCommand(ObjectAdapter object) {
        CreateObjectCommand createObjectCommand = this.newCreateObjectCommand(object);
        this.transactionManager.addCommand(createObjectCommand);
    }

    private static boolean alreadyPersistedOrNotPersistable(ObjectAdapter adapter) {
        return adapter.representsPersistent() || PersistenceSession.objectSpecNotPersistable(adapter);
    }

    private static boolean objectSpecNotPersistable(ObjectAdapter adapter) {
        return !adapter.getSpecification().persistability().isPersistable() || adapter.isParentedCollection();
    }

    public void makePersistent(ObjectAdapter adapter) {
        this.makePersistentInTransaction(adapter);
    }

    public void remove(ObjectAdapter adapter) {
        this.destroyObjectInTransaction(adapter);
    }

    public void destroyObjectInTransaction(final ObjectAdapter adapter) {
        ObjectSpecification spec = adapter.getSpecification();
        if (spec.isParented()) {
            return;
        }
        LOG.debug("destroyObject {}", (Object)adapter);
        this.transactionManager.executeWithinTransaction(new TransactionalClosure(){

            public void execute() {
                DestroyObjectCommand command = PersistenceSession.this.newDestroyObjectCommand(adapter);
                PersistenceSession.this.transactionManager.addCommand(command);
            }
        });
    }

    private CreateObjectCommand newCreateObjectCommand(ObjectAdapter adapter) {
        this.ensureOpened();
        LOG.debug("create object - creating command for: {}", (Object)adapter);
        if (adapter.representsPersistent()) {
            throw new IllegalArgumentException("Adapter is persistent; adapter: " + adapter);
        }
        return new DataNucleusCreateObjectCommand(adapter, this.persistenceManager);
    }

    private DestroyObjectCommand newDestroyObjectCommand(ObjectAdapter adapter) {
        this.ensureOpened();
        LOG.debug("destroy object - creating command for: {}", (Object)adapter);
        if (!adapter.representsPersistent()) {
            throw new IllegalArgumentException("Adapter is not persistent; adapter: " + adapter);
        }
        return new DataNucleusDeleteObjectCommand(adapter, this.persistenceManager);
    }

    public void execute(List<PersistenceCommand> commands) {
        this.executeCommands(commands);
    }

    private void executeCommands(List<PersistenceCommand> commands) {
        for (PersistenceCommand command : commands) {
            command.execute(null);
        }
        this.persistenceManager.flush();
    }

    public ObjectAdapter getAggregateRoot(ParentedCollectionOid collectionOid) {
        RootOid rootOid = collectionOid.getRootOid();
        ObjectAdapter rootadapter = this.getAdapterFor((Oid)rootOid);
        if (rootadapter == null) {
            Oid parentOidNowPersisted = this.remappedFrom((Oid)rootOid);
            rootadapter = this.getAdapterFor(parentOidNowPersisted);
        }
        return rootadapter;
    }

    private Oid remappedFrom(Oid transientOid) {
        return this.persistentByTransient.get(transientOid);
    }

    @Override
    public void startTransaction() {
        Transaction transaction = this.persistenceManager.currentTransaction();
        if (transaction.isActive()) {
            throw new IllegalStateException("Transaction already active");
        }
        transaction.begin();
    }

    @Override
    public void endTransaction() {
        Transaction transaction = this.persistenceManager.currentTransaction();
        if (transaction.isActive()) {
            transaction.commit();
        }
    }

    @Override
    public void abortTransaction() {
        Transaction transaction = this.persistenceManager.currentTransaction();
        if (transaction.isActive()) {
            transaction.rollback();
        }
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    public ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }

    public IsisTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public javax.jdo.Query newJdoQuery(Class<?> cls) {
        return this.persistenceManager.newQuery(cls);
    }

    public javax.jdo.Query newJdoNamedQuery(Class<?> cls, String queryName) {
        return this.persistenceManager.newNamedQuery(cls, queryName);
    }

    public javax.jdo.Query newJdoQuery(Class<?> cls, String filter) {
        return this.persistenceManager.newQuery(cls, filter);
    }

    public ObjectAdapter getAdapterFor(Object pojo) {
        Ensure.ensureThatArg((Object)pojo, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        return this.pojoAdapterMap.getAdapter(pojo);
    }

    public ObjectAdapter getAdapterFor(Oid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.ensureMapsConsistent(oid);
        return this.oidAdapterMap.getAdapter(oid);
    }

    private ObjectAdapter existingOrValueAdapter(Object pojo) {
        Object adapter = this.getAdapterFor(pojo);
        if (adapter != null) {
            return adapter;
        }
        adapter = pojo instanceof Persistable ? this.mapPersistent((Persistable)pojo) : null;
        if (adapter != null) {
            return adapter;
        }
        ObjectSpecification objSpec = this.specificationLoader.loadSpecification(pojo.getClass());
        if (objSpec.containsFacet(ValueFacet.class)) {
            adapter = this.createStandaloneAdapter(pojo);
            return adapter;
        }
        return null;
    }

    private void ensureMapsConsistent(ObjectAdapter adapter) {
        if (adapter.isValue()) {
            return;
        }
        if (adapter.isParentedCollection()) {
            return;
        }
        this.ensurePojoAdapterMapConsistent(adapter);
        this.ensureOidAdapterMapConsistent(adapter);
    }

    private void ensureMapsConsistent(Oid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ObjectAdapter adapter = this.oidAdapterMap.getAdapter(oid);
        if (adapter == null) {
            return;
        }
        this.ensureOidAdapterMapConsistent(adapter);
        this.ensurePojoAdapterMapConsistent(adapter);
    }

    private void ensurePojoAdapterMapConsistent(ObjectAdapter adapter) {
        Object adapterPojo = adapter.getObject();
        ObjectAdapter adapterAccordingToMap = this.pojoAdapterMap.getAdapter(adapterPojo);
        if (adapterPojo == null) {
            return;
        }
        this.ensureMapConsistent(adapter, adapterAccordingToMap, "PojoAdapterMap");
    }

    private void ensureOidAdapterMapConsistent(ObjectAdapter adapter) {
        Oid adapterOid = adapter.getOid();
        ObjectAdapter adapterAccordingToMap = this.oidAdapterMap.getAdapter(adapterOid);
        if (adapterOid == null) {
            return;
        }
        this.ensureMapConsistent(adapter, adapterAccordingToMap, "OidAdapterMap");
    }

    private void ensureMapConsistent(ObjectAdapter adapter, ObjectAdapter adapterAccordingToMap, String mapName) {
        Oid adapterOid = adapter.getOid();
        if (adapterAccordingToMap == null) {
            throw new IllegalStateException("mismatch in " + mapName + ": provided adapter's OID: " + adapterOid + "; but no adapter found in map");
        }
        Ensure.ensureThatArg((Object)adapter, (Matcher)CoreMatchers.is((Object)adapterAccordingToMap), (String)("mismatch in " + mapName + ": provided adapter's OID: " + adapterOid + ", \n" + "but map's adapter's OID was: " + adapterAccordingToMap.getOid()));
    }

    public ObjectAdapter adapterForAny(RootOid rootOid) {
        ObjectSpecId specId = rootOid.getObjectSpecId();
        ObjectSpecification spec = this.getSpecificationLoader().lookupBySpecId(specId);
        if (spec == null) {
            return null;
        }
        if (spec.containsFacet(ViewModelFacet.class)) {
            if (!rootOid.isViewModel()) {
                rootOid = new RootOid(rootOid.getObjectSpecId(), rootOid.getIdentifier(), Oid.State.VIEWMODEL);
            }
            try {
                return this.adapterFor(rootOid);
            }
            catch (ObjectNotFoundException ex) {
                return null;
            }
            catch (PojoRecreationException ex) {
                return null;
            }
        }
        try {
            ObjectAdapter objectAdapter = this.loadObjectInTransaction(rootOid);
            return objectAdapter.isTransient() ? null : objectAdapter;
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    public Map<RootOid, ObjectAdapter> adaptersFor(List<RootOid> rootOids) {
        return this.adaptersFor(rootOids, AdapterManager.ConcurrencyChecking.NO_CHECK);
    }

    public Map<RootOid, ObjectAdapter> adaptersFor(List<RootOid> rootOids, AdapterManager.ConcurrencyChecking concurrencyChecking) {
        LinkedHashMap adapterByOid = Maps.newLinkedHashMap();
        ArrayList notYetLoadedOids = Lists.newArrayList();
        for (RootOid rootOid : rootOids) {
            ObjectAdapter adapter = this.getAdapterFor((Oid)rootOid);
            if (adapter == null && (rootOid.isTransient() || rootOid.isViewModel())) {
                Object pojo = this.recreatePojoTransientOrViewModel(rootOid);
                adapter = this.mapRecreatedPojo((Oid)rootOid, pojo);
                this.sync(concurrencyChecking, adapter, rootOid);
            }
            if (adapter != null) {
                adapterByOid.put(rootOid, adapter);
                continue;
            }
            notYetLoadedOids.add(rootOid);
        }
        Map<RootOid, Object> pojoByOid = this.loadPersistentPojos(notYetLoadedOids);
        for (Map.Entry<RootOid, Object> entry : pojoByOid.entrySet()) {
            ObjectAdapter adapter;
            RootOid rootOid = entry.getKey();
            Object pojo = entry.getValue();
            if (pojo == null) continue;
            try {
                adapter = this.mapRecreatedPojo((Oid)rootOid, pojo);
                adapterByOid.put(rootOid, adapter);
            }
            catch (ObjectNotFoundException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new PojoRecreationException((Oid)rootOid, (Throwable)ex);
            }
            this.sync(concurrencyChecking, adapter, rootOid);
        }
        return adapterByOid;
    }

    public ObjectAdapter adapterFor(RootOid rootOid) {
        return this.adapterFor(rootOid, AdapterManager.ConcurrencyChecking.NO_CHECK);
    }

    public ObjectAdapter adapterFor(RootOid rootOid, AdapterManager.ConcurrencyChecking concurrencyChecking) {
        ObjectAdapter adapter = this.getAdapterFor((Oid)rootOid);
        if (adapter == null) {
            try {
                Object pojo = rootOid.isTransient() || rootOid.isViewModel() ? this.recreatePojoTransientOrViewModel(rootOid) : this.loadPersistentPojo(rootOid);
                adapter = this.mapRecreatedPojo((Oid)rootOid, pojo);
            }
            catch (ObjectNotFoundException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new PojoRecreationException((Oid)rootOid, (Throwable)ex);
            }
        }
        this.sync(concurrencyChecking, adapter, rootOid);
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(AdapterManager.ConcurrencyChecking concurrencyChecking, ObjectAdapter adapter, RootOid rootOid) {
        Oid adapterOid = adapter.getOid();
        if (adapterOid instanceof RootOid) {
            RootOid originalOid;
            RootOid recreatedOid;
            block8: {
                recreatedOid = (RootOid)adapterOid;
                originalOid = rootOid;
                try {
                    if (!concurrencyChecking.isChecking()) break block8;
                    Version otherVersion = originalOid.getVersion();
                    Version thisVersion = recreatedOid.getVersion();
                    if (thisVersion == null || otherVersion == null || !thisVersion.different(otherVersion)) break block8;
                    if (this.concurrencyCheckingGloballyEnabled && AdapterManager.ConcurrencyChecking.isCurrentlyEnabled()) {
                        LOG.info("concurrency conflict detected on {} ({})", (Object)recreatedOid, (Object)otherVersion);
                        String currentUser = this.authenticationSession.getUserName();
                        throw new ConcurrencyException(currentUser, (Oid)recreatedOid, thisVersion, otherVersion);
                    }
                    LOG.info("concurrency conflict detected but suppressed, on {} ({})", (Object)recreatedOid, (Object)otherVersion);
                }
                catch (Throwable throwable) {
                    Version originalVersion = originalOid.getVersion();
                    Version recreatedVersion = recreatedOid.getVersion();
                    if (recreatedVersion != null && (originalVersion == null || recreatedVersion.different(originalVersion))) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("updating version in oid, on {} ({}) to ({})", new Object[]{originalOid, originalVersion, recreatedVersion});
                        }
                        originalOid.setVersion(recreatedVersion);
                    }
                    throw throwable;
                }
            }
            Version originalVersion = originalOid.getVersion();
            Version recreatedVersion = recreatedOid.getVersion();
            if (recreatedVersion != null && (originalVersion == null || recreatedVersion.different(originalVersion))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("updating version in oid, on {} ({}) to ({})", new Object[]{originalOid, originalVersion, recreatedVersion});
                }
                originalOid.setVersion(recreatedVersion);
            }
        }
    }

    private Object recreatePojoTransientOrViewModel(RootOid rootOid) {
        Object pojo;
        ObjectSpecification spec = this.specificationLoader.lookupBySpecId(rootOid.getObjectSpecId());
        if (rootOid.isViewModel()) {
            String memento = rootOid.getIdentifier();
            pojo = this.recreateViewModel(spec, memento);
        } else {
            pojo = this.instantiateAndInjectServices(spec);
        }
        return pojo;
    }

    public ObjectAdapter adapterFor(Object pojo) {
        if (pojo == null) {
            return null;
        }
        ObjectAdapter existingOrValueAdapter = this.existingOrValueAdapter(pojo);
        if (existingOrValueAdapter != null) {
            return existingOrValueAdapter;
        }
        ObjectAdapter newAdapter = this.createTransientOrViewModelRootAdapter(pojo);
        return this.mapAndInjectServices(newAdapter);
    }

    public ObjectAdapter adapterFor(Object pojo, ObjectAdapter parentAdapter, OneToManyAssociation collection) {
        assert (parentAdapter != null);
        assert (collection != null);
        ObjectAdapter existingOrValueAdapter = this.existingOrValueAdapter(pojo);
        if (existingOrValueAdapter != null) {
            return existingOrValueAdapter;
        }
        ObjectAdapter newAdapter = this.createCollectionAdapter(pojo, parentAdapter, collection);
        return this.mapAndInjectServices(newAdapter);
    }

    private ObjectAdapter createCollectionAdapter(Object pojo, ObjectAdapter parentAdapter, OneToManyAssociation otma) {
        this.ensureMapsConsistent(parentAdapter);
        Assert.assertNotNull((Object)pojo);
        Oid parentOid = parentAdapter.getOid();
        ParentedCollectionOid collectionOid = new ParentedCollectionOid((RootOid)parentOid, otma);
        ObjectAdapter collectionAdapter = this.createCollectionAdapter(pojo, collectionOid);
        TypeOfFacet facet = (TypeOfFacet)otma.getFacet(TypeOfFacet.class);
        collectionAdapter.setElementSpecificationProvider(ElementSpecificationProviderFromTypeOfFacet.createFrom((TypeOfFacet)facet));
        return collectionAdapter;
    }

    public void remapAsPersistent(ObjectAdapter adapter, RootOid hintRootOid) {
        RootOid persistedRootOid;
        ObjectAdapter rootAdapter = adapter.getAggregateRoot();
        RootOid transientRootOid = (RootOid)rootAdapter.getOid();
        RootAndCollectionAdapters rootAndCollectionAdapters = new RootAndCollectionAdapters(adapter, this);
        LOG.debug("remapAsPersistent: {}", (Object)transientRootOid);
        LOG.debug("removing root adapter from oid map");
        boolean removed = this.oidAdapterMap.remove((Oid)transientRootOid);
        if (!removed) {
            LOG.warn("could not remove oid: {}", (Object)transientRootOid);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing collection adapter(s) from oid map");
        }
        for (ObjectAdapter collectionAdapter : rootAndCollectionAdapters) {
            Oid collectionOid = collectionAdapter.getOid();
            removed = this.oidAdapterMap.remove(collectionOid);
            if (removed) continue;
            LOG.warn("could not remove collectionOid: {}", (Object)collectionOid);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("updating the Oid");
        }
        if (hintRootOid != null) {
            ObjectSpecId adapterObjectSpecId;
            if (hintRootOid.isTransient()) {
                throw new IsisAssertException("hintRootOid must be persistent");
            }
            ObjectSpecId hintRootOidObjectSpecId = hintRootOid.getObjectSpecId();
            if (!hintRootOidObjectSpecId.equals((Object)(adapterObjectSpecId = adapter.getSpecification().getSpecId()))) {
                throw new IsisAssertException("hintRootOid's objectType must be same as that of adapter (was: '" + hintRootOidObjectSpecId + "'; adapter's is " + adapterObjectSpecId + "'");
            }
            persistedRootOid = hintRootOid;
        } else {
            persistedRootOid = this.createPersistentOrViewModelOid(adapter.getObject());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("replacing Oid for root adapter and re-adding into maps; oid is now: {} (was: {})", (Object)persistedRootOid.enString(), (Object)transientRootOid.enString());
        }
        adapter.replaceOid((Oid)persistedRootOid);
        this.oidAdapterMap.add((Oid)persistedRootOid, adapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("replacing Oids for collection adapter(s) and re-adding into maps");
        }
        for (ObjectAdapter collectionAdapter : rootAndCollectionAdapters) {
            ParentedCollectionOid previousCollectionOid = (ParentedCollectionOid)collectionAdapter.getOid();
            ParentedCollectionOid persistedCollectionOid = previousCollectionOid.asPersistent(persistedRootOid);
            this.oidAdapterMap.add((Oid)persistedCollectionOid, collectionAdapter);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("synchronizing collection pojos, remapping in pojo map if required");
        }
        for (OneToManyAssociation otma : rootAndCollectionAdapters.getCollections()) {
            ObjectAdapter collectionAdapter = rootAndCollectionAdapters.getCollectionAdapter(otma);
            Object collectionPojoWrappedByAdapter = collectionAdapter.getObject();
            Object collectionPojoActuallyOnPojo = PersistenceSession.getCollectionPojo(otma, adapter);
            if (collectionPojoActuallyOnPojo == collectionPojoWrappedByAdapter) continue;
            this.pojoAdapterMap.remove(collectionAdapter);
            collectionAdapter.replacePojo(collectionPojoActuallyOnPojo);
            this.pojoAdapterMap.add(collectionPojoActuallyOnPojo, collectionAdapter);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("made persistent {}; was {}", (Object)adapter, (Object)transientRootOid);
        }
    }

    private static Object getCollectionPojo(OneToManyAssociation association, ObjectAdapter ownerAdapter) {
        PropertyOrCollectionAccessorFacet accessor = (PropertyOrCollectionAccessorFacet)association.getFacet(PropertyOrCollectionAccessorFacet.class);
        return accessor.getProperty(ownerAdapter, InteractionInitiatedBy.FRAMEWORK);
    }

    public ObjectAdapter mapRecreatedPojo(Oid oid, Object recreatedPojo) {
        ObjectAdapter adapterLookedUpByPojo = this.getAdapterFor(recreatedPojo);
        if (adapterLookedUpByPojo != null) {
            return adapterLookedUpByPojo;
        }
        ObjectAdapter adapterLookedUpByOid = this.getAdapterFor(oid);
        if (adapterLookedUpByOid != null) {
            return adapterLookedUpByOid;
        }
        ObjectAdapter createdAdapter = this.createRootOrAggregatedAdapter(oid, recreatedPojo);
        return this.mapAndInjectServices(createdAdapter);
    }

    public void removeAdapter(ObjectAdapter adapter) {
        this.ensureMapsConsistent(adapter);
        LOG.debug("removing adapter: {}", (Object)adapter);
        this.unmap(adapter);
    }

    private void unmap(ObjectAdapter adapter) {
        this.ensureMapsConsistent(adapter);
        Oid oid = adapter.getOid();
        if (oid != null) {
            this.oidAdapterMap.remove(oid);
        }
        this.pojoAdapterMap.remove(adapter);
    }

    public void remapRecreatedPojo(ObjectAdapter adapter, Object pojo) {
        this.removeAdapter(adapter);
        adapter.replacePojo(pojo);
        this.mapAndInjectServices(adapter);
    }

    private ObjectAdapter createRootOrAggregatedAdapter(Oid oid, Object pojo) {
        ObjectAdapter createdAdapter;
        if (oid instanceof RootOid) {
            RootOid rootOid = (RootOid)oid;
            createdAdapter = this.createRootAdapter(pojo, rootOid);
        } else {
            ParentedCollectionOid collectionOid = (ParentedCollectionOid)oid;
            createdAdapter = this.createCollectionAdapter(pojo, collectionOid);
        }
        return createdAdapter;
    }

    private ObjectAdapter createTransientOrViewModelRootAdapter(Object pojo) {
        RootOid rootOid = this.createTransientOrViewModelOid(pojo);
        return this.createRootAdapter(pojo, rootOid);
    }

    private ObjectAdapter createStandaloneAdapter(Object pojo) {
        return this.createAdapter(pojo, null);
    }

    private ObjectAdapter createRootAdapter(Object pojo, RootOid rootOid) {
        assert (rootOid != null);
        return this.createAdapter(pojo, (Oid)rootOid);
    }

    private ObjectAdapter createCollectionAdapter(Object pojo, ParentedCollectionOid collectionOid) {
        assert (collectionOid != null);
        return this.createAdapter(pojo, (Oid)collectionOid);
    }

    private PojoAdapter createAdapter(Object pojo, Oid oid) {
        return new PojoAdapter(pojo, oid, this.authenticationSession, this.specificationLoader, this);
    }

    private ObjectAdapter mapAndInjectServices(ObjectAdapter adapter) {
        Assert.assertNotNull((Object)adapter);
        Object pojo = adapter.getObject();
        Assert.assertFalse((String)"POJO Map already contains object", (Object)pojo, (boolean)this.pojoAdapterMap.containsPojo(pojo));
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding identity for adapter with oid={}", (Object)adapter.getOid());
        }
        if (adapter.isValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not mapping value adapter");
            }
            this.servicesInjector.injectServicesInto(pojo);
            return adapter;
        }
        ObjectSpecification objSpec = adapter.getSpecification();
        if (!adapter.isParentedCollection() || adapter.isParentedCollection() && !objSpec.isImmutable()) {
            this.pojoAdapterMap.add(pojo, adapter);
        }
        this.oidAdapterMap.add(adapter.getOid(), adapter);
        this.servicesInjector.injectServicesInto(pojo);
        return adapter;
    }

    protected IsisTransaction getCurrentTransaction() {
        return this.transactionManager.getCurrentTransaction();
    }

    @Override
    public void enlistDeletingAndInvokeIsisRemovingCallbackFacet(Persistable pojo) {
        ObjectAdapter adapter = this.adapterFor(pojo);
        this.changedObjectsServiceInternal.enlistDeleting(adapter);
        CallbackFacet.Util.callCallback((ObjectAdapter)adapter, RemovingCallbackFacet.class);
        this.postLifecycleEventIfRequired(adapter, RemovingLifecycleEventFacet.class);
    }

    @Override
    public void initializeMapAndCheckConcurrency(Persistable pojo) {
        Persistable pc = pojo;
        this.servicesInjector.injectInto((Object)pojo);
        Version datastoreVersion = this.getVersionIfAny(pc);
        ObjectAdapter adapter = this.getAdapterFor(pojo);
        if (adapter != null) {
            this.ensureRootObject(pojo);
            RootOid originalOid = (RootOid)adapter.getOid();
            Version originalVersion = adapter.getVersion();
            this.remapRecreatedPojo(adapter, pojo);
            RootOid thisOid = originalOid;
            Version thisVersion = originalVersion;
            Version otherVersion = datastoreVersion;
            if (thisVersion != null && otherVersion != null && thisVersion.different(otherVersion)) {
                if (AdapterManager.ConcurrencyChecking.isCurrentlyEnabled()) {
                    LOG.info("concurrency conflict detected on {} ({})", (Object)thisOid, (Object)otherVersion);
                    String currentUser = this.authenticationSession.getUserName();
                    ConcurrencyException abortCause = new ConcurrencyException(currentUser, (Oid)thisOid, thisVersion, otherVersion);
                    this.getCurrentTransaction().setAbortCause((IsisException)abortCause);
                } else {
                    LOG.info("concurrency conflict detected but suppressed, on {} ({})", (Object)thisOid, (Object)otherVersion);
                }
            }
        } else {
            RootOid originalOid = this.createPersistentOrViewModelOid(pojo);
            adapter = this.getAdapterFor((Oid)originalOid);
            if (adapter != null) {
                this.remapRecreatedPojo(adapter, pojo);
            } else {
                adapter = this.mapRecreatedPojo((Oid)originalOid, pojo);
                CallbackFacet.Util.callCallback((ObjectAdapter)adapter, LoadedCallbackFacet.class);
                this.postLifecycleEventIfRequired(adapter, LoadedLifecycleEventFacet.class);
            }
        }
        adapter.setVersion(datastoreVersion);
    }

    public final RootOid createTransientOrViewModelOid(Object pojo) {
        return this.newIdentifier(pojo, Type.TRANSIENT);
    }

    public final RootOid createPersistentOrViewModelOid(Object pojo) {
        return this.newIdentifier(pojo, Type.PERSISTENT);
    }

    private RootOid newIdentifier(Object pojo, Type type) {
        ObjectSpecification spec = this.objectSpecFor(pojo);
        if (spec.isService()) {
            return this.newRootId(spec, SERVICE_IDENTIFIER, type);
        }
        ViewModelFacet recreatableObjectFacet = (ViewModelFacet)spec.getFacet(ViewModelFacet.class);
        String identifier = recreatableObjectFacet != null ? recreatableObjectFacet.memento(pojo) : this.newIdentifierFor(pojo, type);
        return this.newRootId(spec, identifier, type);
    }

    private String newIdentifierFor(Object pojo, Type type) {
        return type == Type.TRANSIENT ? UUID.randomUUID().toString() : JdoObjectIdSerializer.toOidIdentifier(this.getPersistenceManager().getObjectId(pojo));
    }

    private RootOid newRootId(ObjectSpecification spec, String identifier, Type type) {
        Oid.State state = spec.containsDoOpFacet(ViewModelFacet.class) ? Oid.State.VIEWMODEL : (type == Type.TRANSIENT ? Oid.State.TRANSIENT : Oid.State.PERSISTENT);
        ObjectSpecId objectSpecId = spec.getSpecId();
        return new RootOid(objectSpecId, identifier, state);
    }

    private ObjectSpecification objectSpecFor(Object pojo) {
        Class<?> pojoClass = pojo.getClass();
        return this.getSpecificationLoader().loadSpecification(pojoClass);
    }

    @Override
    public void invokeIsisPersistingCallback(Persistable pojo) {
        ObjectAdapter adapter = this.getAdapterFor(pojo);
        if (adapter == null) {
            return;
        }
        RootOid isisOid = (RootOid)adapter.getOid();
        if (isisOid.isTransient()) {
            CallbackFacet.Util.callCallback((ObjectAdapter)adapter, PersistingCallbackFacet.class);
            this.postLifecycleEventIfRequired(adapter, PersistingLifecycleEventFacet.class);
        }
    }

    @Override
    public void enlistCreatedAndRemapIfRequiredThenInvokeIsisInvokePersistingOrUpdatedCallback(Persistable pojo) {
        ObjectAdapter adapter = this.adapterFor(pojo);
        RootOid rootOid = (RootOid)adapter.getOid();
        if (rootOid.isTransient()) {
            RootOid persistentOid = this.createPersistentOrViewModelOid(pojo);
            this.remapAsPersistent(adapter, persistentOid);
            CallbackFacet.Util.callCallback((ObjectAdapter)adapter, PersistedCallbackFacet.class);
            this.postLifecycleEventIfRequired(adapter, PersistedLifecycleEventFacet.class);
            this.changedObjectsServiceInternal.enlistCreated(adapter);
        } else {
            CallbackFacet.Util.callCallback((ObjectAdapter)adapter, UpdatedCallbackFacet.class);
            this.postLifecycleEventIfRequired(adapter, UpdatedLifecycleEventFacet.class);
        }
        Version versionIfAny = this.getVersionIfAny(pojo);
        adapter.setVersion(versionIfAny);
    }

    @Override
    public void enlistUpdatingAndInvokeIsisUpdatingCallback(Persistable pojo) {
        ObjectAdapter adapter = this.getAdapterFor(pojo);
        if (adapter == null && (adapter = this.mapPersistent(pojo)) == null) {
            throw new RuntimeException("DN could not find objectId for pojo (unexpected) and so could not map into Isis; pojo=[" + pojo + "]");
        }
        if (adapter.isTransient()) {
            return;
        }
        boolean wasAlreadyEnlisted = this.changedObjectsServiceInternal.isEnlisted(adapter);
        this.changedObjectsServiceInternal.enlistUpdating(adapter);
        if (!wasAlreadyEnlisted) {
            CallbackFacet.Util.callCallback((ObjectAdapter)adapter, UpdatingCallbackFacet.class);
            this.postLifecycleEventIfRequired(adapter, UpdatingLifecycleEventFacet.class);
        }
        this.ensureRootObject(pojo);
    }

    @Override
    public void ensureRootObject(Persistable pojo) {
        Oid oid = this.adapterFor(pojo).getOid();
        if (!(oid instanceof RootOid)) {
            throw new IsisException(MessageFormat.format("Not a RootOid: oid={0}, for {1}", oid, pojo));
        }
    }

    private Version getVersionIfAny(Persistable pojo) {
        return Utils.getVersionIfAny(pojo, this.authenticationSession);
    }

    public Object lookup(Bookmark bookmark, BookmarkService2.FieldResetPolicy fieldResetPolicy) {
        RootOid oid = RootOid.create((Bookmark)bookmark);
        ObjectAdapter adapter = this.adapterFor(oid);
        if (adapter == null) {
            return null;
        }
        if (fieldResetPolicy == BookmarkService2.FieldResetPolicy.RESET && !adapter.getSpecification().isViewModel()) {
            this.refreshRootInTransaction(adapter);
        } else {
            this.loadObjectInTransaction(oid);
        }
        return adapter.getObject();
    }

    public boolean flush() {
        return this.getTransactionManager().flushTransaction();
    }

    private <T> T lookupService(Class<T> serviceType) {
        T service = this.lookupServiceIfAny(serviceType);
        if (service == null) {
            throw new IllegalStateException("Could not locate service of type '" + serviceType + "'");
        }
        return service;
    }

    private <T> T lookupServiceIfAny(Class<T> serviceType) {
        return (T)this.servicesInjector.lookupService(serviceType);
    }

    private <T> List<T> lookupServices(Class<T> serviceClass) {
        return this.servicesInjector.lookupServices(serviceClass);
    }

    public String toString() {
        return new ToString((Object)this).toString();
    }

    static enum Type {
        TRANSIENT,
        PERSISTENT;

    }

    private static enum Variant {
        TRANSIENT,
        VIEW_MODEL;

    }

    private static enum State {
        NOT_INITIALIZED,
        OPEN,
        CLOSED;

    }
}

