/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.internal;

import java.util.Locale;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisLocaleInitializer {
    public static final Logger LOG = LoggerFactory.getLogger(IsisLocaleInitializer.class);

    public void initLocale(IsisConfiguration configuration) {
        String localeSpec = configuration.getString("isis.locale");
        if (localeSpec != null) {
            Locale locale;
            int pos = localeSpec.indexOf(95);
            if (pos == -1) {
                locale = new Locale(localeSpec, "");
            } else {
                String language = localeSpec.substring(0, pos);
                String country = localeSpec.substring(pos + 1);
                locale = new Locale(language, country);
            }
            Locale.setDefault(locale);
            LOG.info("locale set to {}", (Object)locale);
        }
        LOG.debug("locale is {}", (Object)Locale.getDefault());
    }
}

