/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.context;

import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IsisContext {
    private static final Logger LOG = LoggerFactory.getLogger(IsisContext.class);
    private static MetaModelInvalidException metamodelInvalidException;
    private static IsisSessionFactory sessionFactory;

    private IsisContext() {
        throw new IllegalStateException("Never instantiated");
    }

    public static MetaModelInvalidException getMetaModelInvalidExceptionIfAny() {
        return metamodelInvalidException;
    }

    public static void setMetaModelInvalidException(MetaModelInvalidException metaModelInvalid) {
        metamodelInvalidException = metaModelInvalid;
    }

    public static IsisSessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public static void setSessionFactory(IsisSessionFactory sessionFactory) {
        if (IsisContext.sessionFactory != null) {
            throw new IsisException("SessionFactory already set up");
        }
        IsisContext.sessionFactory = sessionFactory;
    }

    public static void testReset() {
        sessionFactory = null;
    }
}

