/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;

public class DeploymentType {
    private static List<DeploymentType> deploymentTypes = Lists.newArrayList();
    public static DeploymentType SERVER = new DeploymentType("SERVER", DeploymentCategory.PRODUCTION);
    public static DeploymentType SERVER_EXPLORATION = new DeploymentType("SERVER_EXPLORATION", DeploymentCategory.EXPLORING);
    public static DeploymentType SERVER_PROTOTYPE = new DeploymentType("SERVER_PROTOTYPE", DeploymentCategory.PROTOTYPING);
    public static DeploymentType UNIT_TESTING = new DeploymentType("UNIT_TESTING", DeploymentCategory.PRODUCTION);
    private final String name;
    private final DeploymentCategory deploymentCategory;

    public static DeploymentType lookup(String str) {
        String underscoredStr = str.replace('-', '_').toUpperCase();
        for (DeploymentType deploymentType : deploymentTypes) {
            if (!underscoredStr.equals(deploymentType.name())) continue;
            return deploymentType;
        }
        throw new IllegalArgumentException(String.format("Unknown deployment type '%s'", str));
    }

    public DeploymentType(String name, DeploymentCategory category) {
        this.deploymentCategory = category;
        this.name = name;
        deploymentTypes.add(this);
    }

    public DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategory;
    }

    public boolean isExploring() {
        return this.deploymentCategory.isExploring();
    }

    public boolean isPrototyping() {
        return this.deploymentCategory.isPrototyping();
    }

    public boolean isProduction() {
        return this.deploymentCategory.isProduction();
    }

    public String friendlyName() {
        return this.nameLowerCase().replace('_', '-');
    }

    public String nameLowerCase() {
        return this.name().toLowerCase();
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }
}

