/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.sessiontemplate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosure;
import org.apache.isis.schema.common.v1.CollectionDto;
import org.apache.isis.schema.common.v1.OidDto;
import org.apache.isis.schema.common.v1.ValueDto;
import org.apache.isis.schema.common.v1.ValueType;
import org.apache.isis.schema.utils.CommonDtoUtils;

public abstract class AbstractIsisSessionTemplate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AuthenticationSession authSession, Object context) {
        try {
            this.getIsisSessionFactory().openSession(authSession);
            PersistenceSession persistenceSession = this.getPersistenceSession();
            persistenceSession.getServicesInjector().injectServicesInto((Object)this);
            this.doExecute(context);
        }
        finally {
            this.getIsisSessionFactory().closeSession();
        }
    }

    protected void doExecute(final Object context) {
        PersistenceSession persistenceSession = this.getPersistenceSession();
        IsisTransactionManager transactionManager = this.getTransactionManager(persistenceSession);
        transactionManager.executeWithinTransaction(new TransactionalClosure(){

            public void execute() {
                AbstractIsisSessionTemplate.this.doExecuteWithTransaction(context);
            }
        });
    }

    protected void doExecuteWithTransaction(Object context) {
    }

    protected final ObjectAdapter adapterFor(Object targetObject) {
        if (targetObject instanceof OidDto) {
            OidDto oidDto = (OidDto)targetObject;
            return this.adapterFor(oidDto);
        }
        if (targetObject instanceof CollectionDto) {
            CollectionDto collectionDto = (CollectionDto)targetObject;
            List valueDtoList = collectionDto.getValue();
            ArrayList pojoList = Lists.newArrayList();
            for (ValueDto valueDto : valueDtoList) {
                ValueType valueType;
                Object valueOrOidDto = CommonDtoUtils.getValue((ValueDto)valueDto, (ValueType)(valueType = collectionDto.getType()));
                ObjectAdapter objectAdapter = this.adapterFor(valueOrOidDto);
                Object pojo = objectAdapter != null ? objectAdapter.getObject() : null;
                pojoList.add(pojo);
            }
            return this.adapterFor(pojoList);
        }
        if (targetObject instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)targetObject;
            return this.adapterFor(bookmark);
        }
        return this.getPersistenceSession().adapterFor(targetObject);
    }

    protected final ObjectAdapter adapterFor(OidDto oidDto) {
        Bookmark bookmark = Bookmark.from((OidDto)oidDto);
        return this.adapterFor(bookmark);
    }

    protected final ObjectAdapter adapterFor(Bookmark bookmark) {
        RootOid rootOid = RootOid.create((Bookmark)bookmark);
        return this.adapterFor(rootOid);
    }

    protected final ObjectAdapter adapterFor(RootOid rootOid) {
        return this.getPersistenceSession().adapterFor(rootOid);
    }

    protected IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    protected PersistenceSession getPersistenceSession() {
        return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
    }

    protected IsisTransactionManager getTransactionManager(PersistenceSession persistenceSession) {
        return persistenceSession.getTransactionManager();
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }
}

