/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.sudo;

import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.sudo.SudoService;
import org.apache.isis.applib.services.user.UserService;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class SudoServiceDefault
implements SudoService {
    @Inject
    private UserService userService;
    @Inject
    private List<SudoService.Spi> spiServices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Programmatic
    public void sudo(String username, Runnable runnable) {
        try {
            this.runAs(username, null);
            runnable.run();
        }
        finally {
            this.releaseRunAs();
        }
    }

    @Programmatic
    public <T> T sudo(String username, Callable<T> callable) {
        try {
            this.runAs(username, null);
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.releaseRunAs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Programmatic
    public void sudo(String username, List<String> roles, Runnable runnable) {
        try {
            this.runAs(username, roles);
            runnable.run();
        }
        finally {
            this.releaseRunAs();
        }
    }

    @Programmatic
    public <T> T sudo(String username, List<String> roles, Callable<T> callable) {
        try {
            this.runAs(username, roles);
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.releaseRunAs();
        }
    }

    private void runAs(String username, List<String> roles) {
        if (this.spiServices != null) {
            for (SudoService.Spi spiService : this.spiServices) {
                spiService.runAs(username, roles);
            }
        }
    }

    private void releaseRunAs() {
        if (this.spiServices != null) {
            for (SudoService.Spi spiService : this.spiServices) {
                spiService.releaseRunAs();
            }
        }
    }
}

