/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.publish;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.PublishedObject;
import org.apache.isis.applib.services.RepresentsInteractionMemberExecution;
import org.apache.isis.applib.services.publish.PublishedObjects;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.schema.chg.v1.ChangesDto;
import org.apache.isis.schema.chg.v1.ObjectsDto;
import org.apache.isis.schema.common.v1.OidDto;
import org.apache.isis.schema.common.v1.OidsDto;
import org.apache.isis.schema.utils.jaxbadapters.JavaSqlTimestampXmlGregorianCalendarAdapter;

public class PublishedObjectsDefault
implements PublishedObjects,
RepresentsInteractionMemberExecution {
    private UUID transactionUuid;
    private final int sequence;
    private final String userName;
    private final Timestamp completedAt;
    private final int numberLoaded;
    private final int numberObjectPropertiesModified;
    private final Map<ObjectAdapter, PublishedObject.ChangeKind> changesByAdapter;
    private ChangesDto dto;
    private Map<PublishedObject.ChangeKind, Collection<ObjectAdapter>> adaptersByChange;

    public PublishedObjectsDefault(UUID transactionUuid, int sequence, String userName, Timestamp completedAt, int numberLoaded, int numberObjectPropertiesModified, Map<ObjectAdapter, PublishedObject.ChangeKind> changesByAdapter) {
        this.transactionUuid = transactionUuid;
        this.sequence = sequence;
        this.userName = userName;
        this.completedAt = completedAt;
        this.numberLoaded = numberLoaded;
        this.numberObjectPropertiesModified = numberObjectPropertiesModified;
        this.changesByAdapter = changesByAdapter;
    }

    @Programmatic
    public UUID getTransactionId() {
        return this.transactionUuid;
    }

    public void setTransactionId(UUID transactionId) {
        this.transactionUuid = transactionId;
    }

    @Programmatic
    public int getSequence() {
        return this.sequence;
    }

    public Timestamp getCompletedAt() {
        return this.completedAt;
    }

    public String getUsername() {
        return this.userName;
    }

    public ChangesDto getDto() {
        return this.dto != null ? this.dto : (this.dto = this.newDto());
    }

    public int getNumberLoaded() {
        return this.numberLoaded;
    }

    public int getNumberCreated() {
        return this.numAdaptersOfKind(PublishedObject.ChangeKind.CREATE);
    }

    public int getNumberUpdated() {
        return this.numAdaptersOfKind(PublishedObject.ChangeKind.UPDATE);
    }

    public int getNumberDeleted() {
        return this.numAdaptersOfKind(PublishedObject.ChangeKind.DELETE);
    }

    public int getNumberPropertiesModified() {
        return this.numberObjectPropertiesModified;
    }

    private int numAdaptersOfKind(PublishedObject.ChangeKind kind) {
        Collection<ObjectAdapter> objectAdapters = this.adaptersByChange().get(kind);
        return objectAdapters != null ? objectAdapters.size() : 0;
    }

    private Map<PublishedObject.ChangeKind, Collection<ObjectAdapter>> adaptersByChange() {
        return this.adaptersByChange != null ? this.adaptersByChange : (this.adaptersByChange = PublishedObjectsDefault.invert(this.changesByAdapter));
    }

    private static <T, S> Map<T, Collection<S>> invert(Map<S, T> valueByKey) {
        return new TreeMap(((ArrayListMultimap)Multimaps.invertFrom((Multimap)Multimaps.forMap(valueByKey), (Multimap)ArrayListMultimap.create())).asMap());
    }

    private ChangesDto newDto() {
        ObjectsDto objectsDto = this.newObjectsDto();
        return this.newChangesDto(objectsDto);
    }

    protected ObjectsDto newObjectsDto() {
        ObjectsDto objectsDto = new ObjectsDto();
        objectsDto.setCreated(this.oidsDtoFor(PublishedObject.ChangeKind.CREATE));
        objectsDto.setUpdated(this.oidsDtoFor(PublishedObject.ChangeKind.UPDATE));
        objectsDto.setDeleted(this.oidsDtoFor(PublishedObject.ChangeKind.DELETE));
        objectsDto.setLoaded(this.getNumberLoaded());
        objectsDto.setPropertiesModified(this.getNumberPropertiesModified());
        return objectsDto;
    }

    private OidsDto oidsDtoFor(PublishedObject.ChangeKind kind) {
        OidsDto oidsDto = new OidsDto();
        Map<PublishedObject.ChangeKind, Collection<ObjectAdapter>> adaptersByChange = this.adaptersByChange();
        Collection<ObjectAdapter> adapters = adaptersByChange.get(kind);
        if (adapters != null) {
            ImmutableList oidDtos = FluentIterable.from(adapters).transform((Function)new Function<ObjectAdapter, OidDto>(){

                public OidDto apply(ObjectAdapter objectAdapter) {
                    RootOid rootOid = (RootOid)objectAdapter.getOid();
                    return rootOid.asOidDto();
                }
            }).toList();
            oidsDto.getOid().addAll(oidDtos);
        }
        return oidsDto;
    }

    protected ChangesDto newChangesDto(ObjectsDto objectsDto) {
        ChangesDto changesDto = new ChangesDto();
        changesDto.setMajorVersion("1");
        changesDto.setMinorVersion("0");
        changesDto.setTransactionId(this.transactionUuid.toString());
        changesDto.setSequence(this.sequence);
        changesDto.setUser(this.userName);
        changesDto.setCompletedAt(JavaSqlTimestampXmlGregorianCalendarAdapter.print((Timestamp)this.completedAt));
        changesDto.setObjects(objectsDto);
        return changesDto;
    }
}

