/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.persistsession;

import java.util.List;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService2;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.xactn.Transaction2;
import org.apache.isis.applib.services.xactn.TransactionState;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosure;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483646")
public class PersistenceSessionServiceInternalDefault
implements PersistenceSessionServiceInternal {
    @Inject
    IsisSessionFactory isisSessionFactory;

    public ObjectAdapter getAdapterFor(Oid oid) {
        return this.getPersistenceSession().getAdapterFor(oid);
    }

    public ObjectAdapter getAdapterFor(Object pojo) {
        return this.getPersistenceSession().getAdapterFor(pojo);
    }

    public ObjectAdapter adapterFor(Object pojo) {
        return this.getPersistenceSession().adapterFor(pojo);
    }

    public ObjectAdapter adapterFor(Object pojo, ObjectAdapter ownerAdapter, OneToManyAssociation collection) {
        return this.getPersistenceSession().adapterFor(pojo, ownerAdapter, collection);
    }

    public ObjectAdapter mapRecreatedPojo(Oid oid, Object recreatedPojo) {
        return this.getPersistenceSession().mapRecreatedPojo(oid, recreatedPojo);
    }

    public void removeAdapter(ObjectAdapter adapter) {
        this.getPersistenceSession().removeAdapter(adapter);
    }

    public void makePersistent(ObjectAdapter adapter) {
        this.getPersistenceSession().makePersistentInTransaction(adapter);
    }

    public void remove(ObjectAdapter adapter) {
        this.getPersistenceSession().destroyObjectInTransaction(adapter);
    }

    public ObjectAdapter createTransientInstance(ObjectSpecification spec) {
        return this.getPersistenceSession().createTransientInstance(spec);
    }

    public ObjectAdapter createViewModelInstance(ObjectSpecification spec, String memento) {
        return this.getPersistenceSession().createViewModelInstance(spec, memento);
    }

    public Object lookup(Bookmark bookmark, BookmarkService2.FieldResetPolicy fieldResetPolicy) {
        return this.getPersistenceSession().lookup(bookmark, fieldResetPolicy);
    }

    public Bookmark bookmarkFor(Object domainObject) {
        ObjectAdapter adapter = this.getPersistenceSession().adapterFor(domainObject);
        Oid oid = adapter.getOid();
        if (oid == null) {
            return null;
        }
        if (!(oid instanceof RootOid)) {
            return null;
        }
        RootOid rootOid = (RootOid)oid;
        return rootOid.asBookmark();
    }

    public Bookmark bookmarkFor(Class<?> cls, String identifier) {
        ObjectSpecification objectSpec = this.getSpecificationLoader().loadSpecification(cls);
        String objectType = objectSpec.getSpecId().asString();
        return new Bookmark(objectType, identifier);
    }

    public void resolve(Object parent) {
        this.getPersistenceSession().resolve(parent);
    }

    @Deprecated
    public void resolve(Object parent, Object field) {
        if (field == null) {
            this.resolve(parent);
        }
    }

    public void beginTran() {
        this.beginTran(null);
    }

    public void beginTran(Command commandIfAny) {
        this.getTransactionManager().startTransaction(commandIfAny);
    }

    public boolean flush() {
        return this.getTransactionManager().flushTransaction();
    }

    public void commit() {
        this.getTransactionManager().endTransaction();
    }

    public void abortTransaction() {
        this.getTransactionManager().abortTransaction();
    }

    public Transaction2 currentTransaction() {
        return this.getTransactionManager().getCurrentTransaction();
    }

    public <T> List<ObjectAdapter> allMatchingQuery(Query<T> query) {
        return this.getPersistenceSession().allMatchingQuery(query);
    }

    public <T> ObjectAdapter firstMatchingQuery(Query<T> query) {
        return this.getPersistenceSession().firstMatchingQuery(query);
    }

    public void executeWithinTransaction(TransactionalClosure transactionalClosure) {
        this.getTransactionManager().executeWithinTransaction(transactionalClosure);
    }

    public TransactionState getTransactionState() {
        IsisTransaction transaction = this.getTransactionManager().getCurrentTransaction();
        if (transaction == null) {
            return TransactionState.NONE;
        }
        IsisTransaction.State state = transaction.getState();
        return state.getTransactionState();
    }

    protected PersistenceSession getPersistenceSession() {
        return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
    }

    private IsisSessionFactory getIsisSessionFactory() {
        return this.isisSessionFactory;
    }

    @Programmatic
    public IsisTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }
}

