/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.message;

import javax.inject.Inject;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483646")
public class MessageServiceDefault
implements MessageService {
    @Inject
    IsisSessionFactory isisSessionFactory;
    @Inject
    TranslationService translationService;

    public void informUser(String message) {
        this.getMessageBroker().addMessage(message);
    }

    public String informUser(TranslatableString message, Class<?> contextClass, String contextMethod) {
        String translatedMessage = message.translate(this.translationService, MessageServiceDefault.context(contextClass, contextMethod));
        this.informUser(translatedMessage);
        return translatedMessage;
    }

    public void warnUser(String message) {
        this.getMessageBroker().addWarning(message);
    }

    public String warnUser(TranslatableString message, Class<?> contextClass, String contextMethod) {
        String translatedMessage = message.translate(this.translationService, MessageServiceDefault.context(contextClass, contextMethod));
        this.warnUser(translatedMessage);
        return translatedMessage;
    }

    public void raiseError(String message) {
        throw new RecoverableException(message);
    }

    public String raiseError(TranslatableString message, Class<?> contextClass, String contextMethod) {
        String translatedMessage = message.translate(this.translationService, MessageServiceDefault.context(contextClass, contextMethod));
        this.raiseError(translatedMessage);
        return translatedMessage;
    }

    private static String context(Class<?> contextClass, String contextMethod) {
        return contextClass.getName() + "#" + contextMethod;
    }

    private MessageBroker getMessageBroker() {
        return this.isisSessionFactory.getCurrentSession().getAuthenticationSession().getMessageBroker();
    }
}

