/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.menubars.bootstrap3;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.applib.layout.component.ServiceActionLayoutData;
import org.apache.isis.applib.layout.menubars.MenuBars;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3Menu;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3MenuBar;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3MenuBars;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3MenuSection;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.menu.MenuBarsLoaderService;
import org.apache.isis.applib.services.menu.MenuBarsService;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.deployment.DeploymentCategoryProvider;
import org.apache.isis.core.metamodel.facets.actions.notinservicemenu.NotInServiceMenuFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceFacet;
import org.apache.isis.core.metamodel.facets.object.domainservicelayout.DomainServiceLayoutFacet;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.services.menubars.bootstrap3.ServiceAndAction;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class MenuBarsServiceBS3
implements MenuBarsService {
    private static final Logger LOG = LoggerFactory.getLogger(MenuBarsServiceBS3.class);
    public static final String MB3_TNS = "http://isis.apache.org/applib/layout/menubars/bootstrap3";
    public static final String MB3_SCHEMA_LOCATION = "http://isis.apache.org/applib/layout/menubars/bootstrap3/menubars.xsd";
    public static final String COMPONENT_TNS = "http://isis.apache.org/applib/layout/component";
    public static final String COMPONENT_SCHEMA_LOCATION = "http://isis.apache.org/applib/layout/component/component.xsd";
    public static final String LINKS_TNS = "http://isis.apache.org/applib/layout/links";
    public static final String LINKS_SCHEMA_LOCATION = "http://isis.apache.org/applib/layout/links/links.xsd";
    BS3MenuBars menuBars;
    @Inject
    IsisSessionFactory isisSessionFactory;
    @Inject
    MenuBarsLoaderService menuBarsLoaderService;
    @Inject
    DeploymentCategoryProvider deploymentCategoryProvider;
    @Inject
    MessageService messageService;
    @Inject
    JaxbService jaxbService;

    @Programmatic
    public BS3MenuBars menuBars() {
        return this.menuBars(MenuBarsService.Type.DEFAULT);
    }

    @Programmatic
    public BS3MenuBars menuBars(MenuBarsService.Type type) {
        BS3MenuBars fallbackMenuBars = this.deriveMenuBarsFromMetaModelFacets();
        if (type == MenuBarsService.Type.FALLBACK) {
            return fallbackMenuBars;
        }
        if (this.menuBars == null || this.menuBarsLoaderService.supportsReloading()) {
            BS3MenuBars menuBars = this.menuBarsLoaderService.menuBars();
            if (menuBars == null) {
                menuBars = fallbackMenuBars;
            }
            menuBars.setTnsAndSchemaLocation(this.tnsAndSchemaLocation());
            final BS3Menu unreferencedActionsMenu = this.validate(menuBars);
            if (unreferencedActionsMenu != null) {
                final LinkedHashMap referencedActionsByObjectTypeAndId = menuBars.getAllServiceActionsByObjectTypeAndId();
                fallbackMenuBars.visit((MenuBars.Visitor)new BS3MenuBars.VisitorAdapter(){

                    public void visit(BS3MenuSection menuSection) {
                        BS3MenuSection section = null;
                        for (ServiceActionLayoutData serviceAction : menuSection.getServiceActions()) {
                            String objectTypeAndId = serviceAction.getObjectTypeAndId();
                            if (referencedActionsByObjectTypeAndId.containsKey(objectTypeAndId)) continue;
                            if (section == null) {
                                section = new BS3MenuSection();
                                unreferencedActionsMenu.getSections().add(section);
                            }
                            serviceAction.setOwner(section);
                            section.getServiceActions().add(serviceAction);
                        }
                    }
                });
            } else {
                menuBars = fallbackMenuBars;
            }
            this.menuBars = menuBars;
        }
        return this.menuBars;
    }

    BS3Menu validate(BS3MenuBars menuBars) {
        if (menuBars == null) {
            return null;
        }
        final ArrayList menusWithUnreferencedActionsFlagSet = Lists.newArrayList();
        menuBars.visit((MenuBars.Visitor)new BS3MenuBars.VisitorAdapter(){

            public void visit(BS3Menu menu) {
                if (this.isSet(menu.isUnreferencedActions()).booleanValue()) {
                    menusWithUnreferencedActionsFlagSet.add(menu);
                }
            }

            private Boolean isSet(Boolean flag) {
                return flag != null && flag != false;
            }
        });
        int size = menusWithUnreferencedActionsFlagSet.size();
        if (size == 1) {
            return (BS3Menu)menusWithUnreferencedActionsFlagSet.get(0);
        }
        menuBars.setMetadataError("Exactly one menu must have 'unreferencedActions' flag set; found " + size + " such menus");
        if (!this.deploymentCategoryProvider.getDeploymentCategory().isProduction()) {
            this.messageService.warnUser("Menubars metadata errors; check the error log");
        }
        LOG.error("Menubar layout metadata errors:\n\n{}\n\n", (Object)this.jaxbService.toXml((Object)menuBars));
        return null;
    }

    private BS3MenuBars deriveMenuBarsFromMetaModelFacets() {
        BS3MenuBars menuBars = new BS3MenuBars();
        List<ObjectAdapter> serviceAdapters = this.isisSessionFactory.getCurrentSession().getPersistenceSession().getServices();
        ImmutableList visibleServiceAdapters = FluentIterable.from(serviceAdapters).filter((Predicate)new Predicate<ObjectAdapter>(){

            public boolean apply(ObjectAdapter objectAdapter) {
                if (objectAdapter == null) {
                    return false;
                }
                if (objectAdapter.getSpecification() == null) {
                    return false;
                }
                ObjectSpecification spec = objectAdapter.getSpecification();
                if (spec.isHidden()) {
                    return false;
                }
                DomainServiceFacet facet = (DomainServiceFacet)spec.getFacet(DomainServiceFacet.class);
                if (facet == null) {
                    return true;
                }
                NatureOfService natureOfService = facet.getNatureOfService();
                return natureOfService == null || natureOfService != NatureOfService.DOMAIN;
            }
        }).toList();
        this.append((List<ObjectAdapter>)visibleServiceAdapters, menuBars.getPrimary(), DomainServiceLayout.MenuBar.PRIMARY);
        this.append((List<ObjectAdapter>)visibleServiceAdapters, menuBars.getSecondary(), DomainServiceLayout.MenuBar.SECONDARY);
        this.append((List<ObjectAdapter>)visibleServiceAdapters, menuBars.getTertiary(), DomainServiceLayout.MenuBar.TERTIARY);
        menuBars.setTnsAndSchemaLocation(this.tnsAndSchemaLocation());
        BS3Menu otherMenu = new BS3Menu();
        otherMenu.setNamed("Other");
        otherMenu.setUnreferencedActions(Boolean.valueOf(true));
        menuBars.getPrimary().getMenus().add(otherMenu);
        return menuBars;
    }

    private void append(List<ObjectAdapter> serviceAdapters, BS3MenuBar menuBar, DomainServiceLayout.MenuBar menuBarPos) {
        ArrayList serviceActions = Lists.newArrayList();
        for (ObjectAdapter serviceAdapter : FluentIterable.from(serviceAdapters).filter(MenuBarsServiceBS3.with(menuBarPos))) {
            this.collateServiceActions(serviceAdapter, ActionType.USER, serviceActions);
            this.collateServiceActions(serviceAdapter, ActionType.PROTOTYPE, serviceActions);
        }
        Set<String> serviceNamesInOrder = MenuBarsServiceBS3.serviceNamesInOrder(serviceAdapters, serviceActions);
        Map<String, List<ServiceAndAction>> serviceActionsByName = MenuBarsServiceBS3.groupByServiceName(serviceActions);
        serviceNamesInOrder.retainAll(serviceActionsByName.keySet());
        List<BS3Menu> menus = MenuBarsServiceBS3.buildMenuItems(serviceNamesInOrder, serviceActionsByName);
        menuBar.getMenus().addAll(menus);
    }

    private static List<BS3Menu> buildMenuItems(Set<String> serviceNamesInOrder, Map<String, List<ServiceAndAction>> serviceActionsByName) {
        ArrayList menus = Lists.newArrayList();
        for (String serviceName : serviceNamesInOrder) {
            BS3Menu menu = new BS3Menu(serviceName);
            menus.add(menu);
            BS3MenuSection menuSection = new BS3MenuSection();
            List<ServiceAndAction> serviceActionsForName = serviceActionsByName.get(serviceName);
            for (ServiceAndAction serviceAndAction : serviceActionsForName) {
                if (serviceAndAction.separator && !menuSection.getServiceActions().isEmpty()) {
                    menu.getSections().add(menuSection);
                    menuSection = new BS3MenuSection();
                }
                ObjectAction objectAction = serviceAndAction.objectAction;
                String objectType = serviceAndAction.serviceAdapter.getSpecification().getSpecId().asString();
                ServiceActionLayoutData action = new ServiceActionLayoutData(objectType, objectAction.getId());
                action.setNamed(objectAction.getName());
                menuSection.getServiceActions().add(action);
            }
            if (menuSection.getServiceActions().isEmpty()) continue;
            menu.getSections().add(menuSection);
        }
        return menus;
    }

    private static Set<String> serviceNamesInOrder(List<ObjectAdapter> serviceAdapters, List<ServiceAndAction> serviceActions) {
        LinkedHashSet serviceNameOrder = Sets.newLinkedHashSet();
        for (ObjectAdapter serviceAdapter : serviceAdapters) {
            ObjectSpecification serviceSpec = serviceAdapter.getSpecification();
            String serviceName = ((NamedFacet)serviceSpec.getFacet(NamedFacet.class)).value();
            serviceNameOrder.add(serviceName);
        }
        for (ServiceAndAction serviceAction : serviceActions) {
            if (serviceNameOrder.contains(serviceAction.serviceName)) continue;
            serviceNameOrder.add(serviceAction.serviceName);
        }
        return serviceNameOrder;
    }

    private static Map<String, List<ServiceAndAction>> groupByServiceName(List<ServiceAndAction> serviceActions) {
        TreeMap serviceActionsByName = Maps.newTreeMap();
        ObjectAdapter lastServiceAdapter = null;
        for (ServiceAndAction serviceAction : serviceActions) {
            List serviceActionsForName = (List)serviceActionsByName.get(serviceAction.serviceName);
            ObjectAdapter serviceAdapter = serviceAction.serviceAdapter;
            if (serviceActionsForName == null) {
                serviceActionsForName = Lists.newArrayList();
                serviceActionsByName.put(serviceAction.serviceName, serviceActionsForName);
            } else {
                serviceAction.separator = lastServiceAdapter != serviceAdapter;
            }
            serviceActionsForName.add(serviceAction);
            lastServiceAdapter = serviceAdapter;
        }
        return serviceActionsByName;
    }

    private void collateServiceActions(ObjectAdapter serviceAdapter, ActionType actionType, List<ServiceAndAction> serviceActions) {
        NatureOfService natureOfService;
        ObjectSpecification serviceSpec = serviceAdapter.getSpecification();
        DomainServiceFacet domainServiceFacet = (DomainServiceFacet)serviceSpec.getFacet(DomainServiceFacet.class);
        if (domainServiceFacet != null && ((natureOfService = domainServiceFacet.getNatureOfService()) == NatureOfService.VIEW_REST_ONLY || natureOfService == NatureOfService.VIEW_CONTRIBUTIONS_ONLY || natureOfService == NatureOfService.DOMAIN)) {
            return;
        }
        for (ObjectAction objectAction : serviceSpec.getObjectActions(actionType, Contributed.INCLUDED, Filters.any())) {
            String serviceName;
            if (objectAction.getFacet(NotInServiceMenuFacet.class) != null) continue;
            MemberOrderFacet memberOrderFacet = (MemberOrderFacet)objectAction.getFacet(MemberOrderFacet.class);
            String string = serviceName = memberOrderFacet != null ? memberOrderFacet.name() : null;
            if (Strings.isNullOrEmpty((String)serviceName)) {
                serviceName = ((NamedFacet)serviceSpec.getFacet(NamedFacet.class)).value();
            }
            serviceActions.add(new ServiceAndAction(serviceName, serviceAdapter, objectAction));
        }
    }

    private static Predicate<ObjectAdapter> with(final DomainServiceLayout.MenuBar menuBar) {
        return new Predicate<ObjectAdapter>(){

            public boolean apply(ObjectAdapter input) {
                DomainServiceLayoutFacet facet = (DomainServiceLayoutFacet)input.getSpecification().getFacet(DomainServiceLayoutFacet.class);
                return facet != null && facet.getMenuBar() == menuBar;
            }
        };
    }

    private String tnsAndSchemaLocation() {
        ArrayList parts = Lists.newArrayList();
        parts.add(MB3_TNS);
        parts.add(MB3_SCHEMA_LOCATION);
        parts.add(COMPONENT_TNS);
        parts.add(COMPONENT_SCHEMA_LOCATION);
        parts.add(LINKS_TNS);
        parts.add(LINKS_SCHEMA_LOCATION);
        return Joiner.on((String)" ").join((Iterable)parts);
    }
}

