/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.menubars;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import javax.inject.Inject;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3MenuBars;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.menu.MenuBarsLoaderService;
import org.apache.isis.core.metamodel.deployment.DeploymentCategoryProvider;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class MenuBarsLoaderServiceDefault
implements MenuBarsLoaderService {
    @Inject
    DeploymentCategoryProvider deploymentCategoryProvider;
    @Inject
    JaxbService jaxbService;
    @Inject
    IsisSessionFactory isisSessionFactory;

    public boolean supportsReloading() {
        return !this.deploymentCategoryProvider.getDeploymentCategory().isProduction();
    }

    public BS3MenuBars menuBars() {
        AppManifest appManifest = this.isisSessionFactory.getAppManifest();
        try {
            URL resource = Resources.getResource(appManifest.getClass(), (String)"menubars.layout.xml");
            String xml = Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
            return (BS3MenuBars)this.jaxbService.fromXml(BS3MenuBars.class, xml);
        }
        catch (Exception e) {
            return null;
        }
    }
}

