/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.i18n.po;

import javax.inject.Inject;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.core.runtime.services.i18n.po.TranslationServicePo;
import org.apache.isis.core.runtime.services.i18n.po.Util;

@DomainService(nature=NatureOfService.VIEW_MENU_ONLY, objectType="isisApplib.TranslationServicePoMenu")
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY, menuOrder="500.700")
public class TranslationServicePoMenu {
    @Inject
    private TranslationServicePo translationService;

    @Action(domainEvent=DownloadPotFileDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download")
    @MemberOrder(sequence="500.700.1")
    public Clob downloadTranslations(@ParameterLayout(named=".pot file name") String potFileName) {
        String chars = this.translationService.toPot();
        return new Clob(Util.withSuffix(potFileName, "pot"), "text/plain", (CharSequence)chars);
    }

    public String default0DownloadTranslations() {
        return "translations.pot";
    }

    @Action(domainEvent=ResetTranslationCacheDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(named="Clear translation cache", cssClassFa="fa-trash")
    @MemberOrder(sequence="500.700.2")
    public void resetTranslationCache() {
        this.translationService.clearCache();
    }

    public boolean hideResetTranslationCache() {
        return this.translationService.getMode().isWrite();
    }

    @Action(domainEvent=SwitchToReadingTranslationsDomainEvent.class, semantics=SemanticsOf.IDEMPOTENT, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-book")
    @MemberOrder(sequence="500.700.2")
    public void switchToReadingTranslations() {
        this.translationService.toggleMode();
    }

    public boolean hideSwitchToReadingTranslations() {
        return this.translationService.getMode().isRead();
    }

    @Action(domainEvent=SwitchToWritingTranslationsDomainEvent.class, semantics=SemanticsOf.IDEMPOTENT, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-pencil")
    @MemberOrder(sequence="500.700.3")
    public void switchToWritingTranslations() {
        this.translationService.toggleMode();
    }

    public boolean hideSwitchToWritingTranslations() {
        return this.translationService.getMode().isWrite();
    }

    public static class SwitchToWritingTranslationsDomainEvent
    extends ActionDomainEvent {
    }

    public static class SwitchToReadingTranslationsDomainEvent
    extends ActionDomainEvent {
    }

    public static class ResetTranslationCacheDomainEvent
    extends ActionDomainEvent {
    }

    public static class DownloadPotFileDomainEvent
    extends ActionDomainEvent {
    }

    public static abstract class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<TranslationServicePoMenu> {
    }
}

