/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.i18n.po;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.isis.applib.services.i18n.LocaleProvider;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.i18n.TranslationsResolver;
import org.apache.isis.core.runtime.services.i18n.po.Block;
import org.apache.isis.core.runtime.services.i18n.po.ContextAndMsgId;
import org.apache.isis.core.runtime.services.i18n.po.PoAbstract;
import org.apache.isis.core.runtime.services.i18n.po.TranslationServicePo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PoReader
extends PoAbstract {
    public static final String DASH = "-";
    public static final String UNDERSCORE = "_";
    public static Logger LOG = LoggerFactory.getLogger(PoReader.class);
    private final Map<Locale, Map<ContextAndMsgId, String>> translationByKeyByLocale = Maps.newHashMap();
    private final Map<Locale, Boolean> usesFallbackByLocale = Maps.newHashMap();
    private final String basename = "translations";
    private final TranslationsResolver translationsResolver;
    private final LocaleProvider localeProvider;
    private List<String> fallback;
    private final Set<String> loggedInfoMessages = Sets.newConcurrentHashSet();

    public PoReader(TranslationServicePo translationServicePo) {
        super(translationServicePo, TranslationService.Mode.READ);
        this.translationsResolver = translationServicePo.getTranslationsResolver();
        if (this.translationsResolver == null) {
            LOG.warn("No translationsResolver available");
        }
        this.localeProvider = translationServicePo.getLocaleProvider();
    }

    void init() {
        this.fallback = this.readUrl("translations.po");
        if (this.fallback == null) {
            LOG.info("No fallback translations found; i18n is in effect disabled for this application");
            this.fallback = Collections.emptyList();
        }
    }

    @Override
    void shutdown() {
    }

    @Override
    public String translate(String context, String msgId) {
        if (this.translationsResolver == null) {
            return msgId;
        }
        return this.translate(context, msgId, ContextAndMsgId.Type.REGULAR);
    }

    @Override
    String translate(String context, String msgId, String msgIdPlural, int num) {
        ContextAndMsgId.Type type;
        String msgIdToUse;
        if (num == 1) {
            msgIdToUse = msgId;
            type = ContextAndMsgId.Type.REGULAR;
        } else {
            msgIdToUse = msgIdPlural;
            type = ContextAndMsgId.Type.PLURAL_ONLY;
        }
        return this.translate(context, msgIdToUse, type);
    }

    void clearCache() {
        this.translationByKeyByLocale.clear();
        this.usesFallbackByLocale.clear();
        this.init();
    }

    private String translate(String context, String msgId, ContextAndMsgId.Type type) {
        Locale targetLocale;
        try {
            targetLocale = this.localeProvider.getLocale();
            if (targetLocale == null) {
                return msgId;
            }
        }
        catch (RuntimeException ex) {
            this.logInfoIfNotPreviously("Failed to obtain locale, returning the original msgId");
            return msgId;
        }
        Map<ContextAndMsgId, String> translationsByKey = this.readAndCacheTranslationsIfRequired(targetLocale);
        ContextAndMsgId key = new ContextAndMsgId(context, msgId, type);
        String translation = this.lookupTranslation(translationsByKey, key);
        if (!Strings.isNullOrEmpty((String)translation)) {
            return translation;
        }
        ContextAndMsgId keyNoContext = new ContextAndMsgId("", msgId, type);
        String translationNoContext = this.lookupTranslation(translationsByKey, keyNoContext);
        if (!Strings.isNullOrEmpty((String)translationNoContext)) {
            return translationNoContext;
        }
        Boolean usesFallback = this.usesFallbackByLocale.get(targetLocale);
        if (usesFallback == null || !usesFallback.booleanValue()) {
            this.logInfoIfNotPreviously("No translation found for: " + key);
        }
        return msgId;
    }

    private String lookupTranslation(Map<ContextAndMsgId, String> translationsByKey, ContextAndMsgId key) {
        String s = translationsByKey.get(key);
        return s != null ? s.trim() : null;
    }

    private Map<ContextAndMsgId, String> readAndCacheTranslationsIfRequired(Locale locale) {
        HashMap translationsByKey = this.translationByKeyByLocale.get(locale);
        if (translationsByKey != null) {
            return translationsByKey;
        }
        translationsByKey = Maps.newHashMap();
        this.read(locale, translationsByKey);
        this.translationByKeyByLocale.put(locale, translationsByKey);
        return translationsByKey;
    }

    private void read(Locale locale, Map<ContextAndMsgId, String> translationsByKey) {
        List<String> contents = this.readPo(locale);
        Block block = new Block();
        for (String line : contents) {
            block = block.parseLine(line, translationsByKey);
        }
    }

    protected List<String> readPo(Locale locale) {
        List<String> lines = this.readPoElseNull(locale);
        if (lines != null) {
            this.usesFallbackByLocale.put(locale, false);
            return lines;
        }
        this.logInfoIfNotPreviously("Could not locate translations for locale: " + locale + ", using fallback");
        this.usesFallbackByLocale.put(locale, true);
        return this.fallback;
    }

    private List<String> readPoElseNull(Locale locale) {
        String country = locale.getCountry().toUpperCase(Locale.ROOT);
        String language = locale.getLanguage().toLowerCase(Locale.ROOT);
        ArrayList candidates = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)language)) {
            if (!Strings.isNullOrEmpty((String)country)) {
                candidates.add("translations-" + language + UNDERSCORE + country + ".po");
                candidates.add("translations-" + language + DASH + country + ".po");
                candidates.add("translations_" + language + UNDERSCORE + country + ".po");
                candidates.add("translations_" + language + DASH + country + ".po");
            }
            candidates.add("translations-" + language + ".po");
            candidates.add("translations_" + language + ".po");
        }
        for (String candidate : candidates) {
            List<String> lines = this.readUrl(candidate);
            if (lines == null) continue;
            return lines;
        }
        return null;
    }

    private List<String> readUrl(String candidate) {
        return this.translationsResolver.readLines(candidate);
    }

    private void logInfoIfNotPreviously(String infoMessage) {
        if (!this.loggedInfoMessages.contains(infoMessage)) {
            LOG.info(infoMessage);
            this.loggedInfoMessages.add(infoMessage);
        }
    }
}

