/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.homepage;

import java.util.List;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.homepage.HomePageProviderService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.actions.homepage.HomePageFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class HomePageProviderServiceDefault
implements HomePageProviderService {
    private static final Logger LOG = LoggerFactory.getLogger(HomePageProviderServiceDefault.class);
    protected static final Where WHERE_FOR_ACTION_INVOCATION = Where.ANYWHERE;
    @Inject
    IsisSessionFactory isisSessionFactory;

    @Programmatic
    public Object homePage() {
        List<ObjectAdapter> serviceAdapters = this.getPersistenceSession().getServices();
        for (ObjectAdapter serviceAdapter : serviceAdapters) {
            ObjectSpecification serviceSpec = serviceAdapter.getSpecification();
            List objectActions = serviceSpec.getObjectActions(Contributed.EXCLUDED);
            for (ObjectAction objectAction : objectActions) {
                Object homePage = this.homePageIfUsable(serviceAdapter, objectAction);
                if (homePage == null) continue;
                return homePage;
            }
        }
        return null;
    }

    protected Object homePageIfUsable(ObjectAdapter serviceAdapter, ObjectAction objectAction) {
        if (!objectAction.containsDoOpFacet(HomePageFacet.class)) {
            return null;
        }
        Consent visibility = objectAction.isVisible(serviceAdapter, InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (visibility.isVetoed()) {
            return null;
        }
        Consent usability = objectAction.isUsable(serviceAdapter, InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (usability.isVetoed()) {
            return null;
        }
        ObjectAdapter mixedInAdapter = null;
        ObjectAdapter[] parameters = new ObjectAdapter[0];
        ObjectAdapter objectAdapter = objectAction.executeWithRuleChecking(serviceAdapter, mixedInAdapter, parameters, InteractionInitiatedBy.USER, WHERE_FOR_ACTION_INVOCATION);
        return objectAdapter != null ? objectAdapter.getObject() : null;
    }

    protected PersistenceSession getPersistenceSession() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }
}

