/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.eventbus.adapter;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.isis.applib.services.eventbus.AbstractDomainEvent;
import org.apache.isis.core.runtime.services.eventbus.EventBusImplementationAbstract;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.GenericEventMessage;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.annotation.AnnotationEventListenerAdapter;

public class EventBusImplementationForAxonSimple
extends EventBusImplementationAbstract {
    private SimpleEventBus simpleEventBus = new SimpleEventBus();
    private Map<Object, AxonEventListenerAdapter> listenerAdapterByDomainService = Maps.newConcurrentMap();

    private AxonEventListenerAdapter adapterFor(Object domainService) {
        AxonEventListenerAdapter annotationEventListenerAdapter = this.listenerAdapterByDomainService.get(domainService);
        if (annotationEventListenerAdapter == null) {
            annotationEventListenerAdapter = new AxonEventListenerAdapter(domainService);
            this.listenerAdapterByDomainService.put(domainService, annotationEventListenerAdapter);
        }
        return annotationEventListenerAdapter;
    }

    public void register(Object domainService) {
        this.simpleEventBus.subscribe((EventListener)this.adapterFor(domainService));
    }

    public void unregister(Object domainService) {
    }

    public void post(Object event) {
        this.simpleEventBus.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)event)});
    }

    @Override
    protected AbstractDomainEvent<?> asDomainEvent(Object event) {
        if (event instanceof GenericEventMessage) {
            GenericEventMessage genericEventMessage = (GenericEventMessage)event;
            Object payload = genericEventMessage.getPayload();
            return this.asDomainEventIfPossible(payload);
        }
        return this.asDomainEventIfPossible(event);
    }

    private AbstractDomainEvent<?> asDomainEventIfPossible(Object event) {
        if (event instanceof AbstractDomainEvent) {
            return (AbstractDomainEvent)event;
        }
        return null;
    }

    class AxonEventListenerAdapter
    extends AnnotationEventListenerAdapter {
        public AxonEventListenerAdapter(Object annotatedEventListener) {
            super(annotatedEventListener);
        }

        public void handle(EventMessage event) {
            try {
                super.handle(event);
            }
            catch (Exception exception) {
                EventBusImplementationForAxonSimple.this.processException(exception, event);
            }
        }
    }
}

