/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.eventbus;

import javax.inject.Inject;
import org.apache.isis.applib.services.eventbus.AbstractDomainEvent;
import org.apache.isis.applib.services.eventbus.EventBusImplementation;
import org.apache.isis.core.commons.exceptions.IsisApplicationException;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventBusImplementationAbstract
implements EventBusImplementation {
    private static final Logger LOG = LoggerFactory.getLogger(EventBusImplementationAbstract.class);
    @Inject
    IsisSessionFactory isisSessionFactory;

    protected void processException(Throwable exception, Object event) {
        AbstractDomainEvent<?> domainEvent = this.asDomainEvent(event);
        if (domainEvent == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring exception '%s' (%s), not a subclass of AbstractDomainEvent", (Object)exception.getMessage(), (Object)exception.getClass().getName());
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exception stack trace (to help diagnose issue): ", exception);
        }
        AbstractDomainEvent.Phase phase = domainEvent.getEventPhase();
        switch (phase) {
            case HIDE: 
            case DISABLE: 
            case VALIDATE: {
                this.veto(exception, domainEvent, phase);
                break;
            }
            case EXECUTING: 
            case EXECUTED: {
                this.abort(exception, phase);
                throw new RuntimeException(exception);
            }
        }
    }

    private void veto(Throwable exception, AbstractDomainEvent<?> domainEvent, AbstractDomainEvent.Phase phase) {
        String exceptionMessage = exception.getMessage();
        LOG.warn("Exception thrown during {} phase, to be safe will veto the domain event, msg='{}', class='{}'", new Object[]{phase, exceptionMessage, exception.getClass().getName()});
        String message = exceptionMessage != null ? exceptionMessage : exception.getClass().getName() + " thrown.";
        domainEvent.veto(message, new Object[0]);
    }

    private void abort(Throwable exception, AbstractDomainEvent.Phase phase) {
        LOG.warn("Exception thrown during {} phase, to be safe will abort the transaction, msg='{}', class='{}'", new Object[]{phase, exception.getMessage(), exception.getClass().getName()});
        this.abortTransaction(exception);
    }

    protected abstract AbstractDomainEvent<?> asDomainEvent(Object var1);

    private void abortTransaction(Throwable exception) {
        this.getTransactionManager().getCurrentTransaction().setAbortCause((IsisException)new IsisApplicationException(exception));
    }

    private IsisTransactionManager getTransactionManager() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession().getTransactionManager();
    }
}

