/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.email;

import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.mail.Authenticator;
import org.apache.commons.mail.DataSourceResolver;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.ImageHtmlEmail;
import org.apache.commons.mail.resolver.DataSourceClassPathResolver;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.email.EmailService;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class EmailServiceDefault
implements EmailService {
    private static final Logger LOG = LoggerFactory.getLogger(EmailServiceDefault.class);
    private static final String ISIS_SERVICE_EMAIL_SENDER_USERNAME = "isis.service.email.sender.username";
    private static final String ISIS_SERVICE_EMAIL_SENDER_ADDRESS = "isis.service.email.sender.address";
    private static final String ISIS_SERVICE_EMAIL_SENDER_PASSWORD = "isis.service.email.sender.password";
    private static final String ISIS_SERVICE_EMAIL_SENDER_HOSTNAME = "isis.service.email.sender.hostname";
    private static final String ISIS_SERVICE_EMAIL_SENDER_HOSTNAME_DEFAULT = "smtp.gmail.com";
    private static final String ISIS_SERVICE_EMAIL_PORT = "isis.service.email.port";
    private static final int ISIS_SERVICE_EMAIL_PORT_DEFAULT = 587;
    private static final String ISIS_SERVICE_EMAIL_TLS_ENABLED = "isis.service.email.tls.enabled";
    private static final boolean ISIS_SERVICE_EMAIL_TLS_ENABLED_DEFAULT = true;
    private static final String ISIS_SERVICE_EMAIL_THROW_EXCEPTION_ON_FAIL = "isis.service.email.throwExceptionOnFail";
    private static final boolean ISIS_SERVICE_EMAIL_THROW_EXCEPTION_ON_FAIL_DEFAULT = true;
    private static final String ISIS_SERVICE_EMAIL_SOCKET_TIMEOUT = "isis.service.email.socketTimeout";
    private static final int ISIS_SERVICE_EMAIL_SOCKET_TIMEOUT_DEFAULT = 2000;
    private static final String ISIS_SERVICE_EMAIL_SOCKET_CONNECTION_TIMEOUT = "isis.service.email.socketConnectionTimeout";
    private static final int ISIS_SERVICE_EMAIL_SOCKET_CONNECTION_TIMEOUT_DEFAULT = 2000;
    private static final String ISIS_SERVICE_EMAIL_OVERRIDE_TO = "isis.service.email.override.to";
    private static final String ISIS_SERVICE_EMAIL_OVERRIDE_CC = "isis.service.email.override.cc";
    private static final String ISIS_SERVICE_EMAIL_OVERRIDE_BCC = "isis.service.email.override.bcc";
    private boolean initialized;
    @Inject
    IsisConfiguration configuration;

    @PostConstruct
    @Programmatic
    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (!this.isConfigured()) {
            LOG.warn("NOT configured");
        } else {
            LOG.debug("configured");
        }
    }

    protected String getSenderEmailUsername() {
        return this.configuration.getString(ISIS_SERVICE_EMAIL_SENDER_USERNAME);
    }

    protected String getSenderEmailAddress() {
        return this.configuration.getString(ISIS_SERVICE_EMAIL_SENDER_ADDRESS);
    }

    protected String getSenderEmailPassword() {
        return this.configuration.getString(ISIS_SERVICE_EMAIL_SENDER_PASSWORD);
    }

    protected String getSenderEmailHostName() {
        return this.configuration.getString(ISIS_SERVICE_EMAIL_SENDER_HOSTNAME, ISIS_SERVICE_EMAIL_SENDER_HOSTNAME_DEFAULT);
    }

    protected Integer getSenderEmailPort() {
        return this.configuration.getInteger(ISIS_SERVICE_EMAIL_PORT, 587);
    }

    protected Boolean getSenderEmailTlsEnabled() {
        return this.configuration.getBoolean(ISIS_SERVICE_EMAIL_TLS_ENABLED, true);
    }

    protected Boolean isThrowExceptionOnFail() {
        return this.configuration.getBoolean(ISIS_SERVICE_EMAIL_THROW_EXCEPTION_ON_FAIL, true);
    }

    protected int getSocketTimeout() {
        return this.configuration.getInteger(ISIS_SERVICE_EMAIL_SOCKET_TIMEOUT, 2000);
    }

    protected int getSocketConnectionTimeout() {
        return this.configuration.getInteger(ISIS_SERVICE_EMAIL_SOCKET_CONNECTION_TIMEOUT, 2000);
    }

    protected String getEmailOverrideTo() {
        return this.configuration.getString(ISIS_SERVICE_EMAIL_OVERRIDE_TO);
    }

    protected String getEmailOverrideCc() {
        return this.configuration.getString(ISIS_SERVICE_EMAIL_OVERRIDE_CC);
    }

    protected String getEmailOverrideBcc() {
        return this.configuration.getString(ISIS_SERVICE_EMAIL_OVERRIDE_BCC);
    }

    public boolean isConfigured() {
        String senderEmailAddress = this.getSenderEmailAddress();
        String senderEmailPassword = this.getSenderEmailPassword();
        return !Strings.isNullOrEmpty((String)senderEmailAddress) && !Strings.isNullOrEmpty((String)senderEmailPassword);
    }

    public boolean send(List<String> toList, List<String> ccList, List<String> bccList, String subject, String body, DataSource ... attachments) {
        try {
            String[] bccListElseOverride;
            String[] ccListElseOverride;
            ImageHtmlEmail email = new ImageHtmlEmail();
            String senderEmailUsername = this.getSenderEmailUsername();
            String senderEmailAddress = this.getSenderEmailAddress();
            String senderEmailPassword = this.getSenderEmailPassword();
            String senderEmailHostName = this.getSenderEmailHostName();
            Integer senderEmailPort = this.getSenderEmailPort();
            Boolean senderEmailTlsEnabled = this.getSenderEmailTlsEnabled();
            int socketTimeout = this.getSocketTimeout();
            int socketConnectionTimeout = this.getSocketConnectionTimeout();
            if (senderEmailUsername != null) {
                email.setAuthenticator((Authenticator)new DefaultAuthenticator(senderEmailUsername, senderEmailPassword));
            } else {
                email.setAuthenticator((Authenticator)new DefaultAuthenticator(senderEmailAddress, senderEmailPassword));
            }
            email.setHostName(senderEmailHostName);
            email.setSmtpPort(senderEmailPort.intValue());
            email.setStartTLSEnabled(senderEmailTlsEnabled.booleanValue());
            email.setDataSourceResolver((DataSourceResolver)new DataSourceClassPathResolver("/", true));
            email.setSocketTimeout(socketTimeout);
            email.setSocketConnectionTimeout(socketConnectionTimeout);
            Properties properties = email.getMailSession().getProperties();
            properties.put("mail.smtps.auth", "true");
            properties.put("mail.debug", "true");
            properties.put("mail.smtps.port", "" + senderEmailPort);
            properties.put("mail.smtps.socketFactory.port", "" + senderEmailPort);
            properties.put("mail.smtps.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail.smtps.socketFactory.fallback", "false");
            properties.put("mail.smtp.starttls.enable", "" + senderEmailTlsEnabled);
            email.setFrom(senderEmailAddress);
            email.setSubject(subject);
            email.setHtmlMsg(body);
            if (attachments != null && attachments.length > 0) {
                for (DataSource attachment : attachments) {
                    email.attach(attachment, attachment.getName(), "");
                }
            }
            String overrideTo = this.getEmailOverrideTo();
            String overrideCc = this.getEmailOverrideCc();
            String overrideBcc = this.getEmailOverrideBcc();
            String[] toListElseOverride = EmailServiceDefault.actually(toList, overrideTo);
            if (EmailServiceDefault.notEmpty(toListElseOverride)) {
                email.addTo(toListElseOverride);
            }
            if (EmailServiceDefault.notEmpty(ccListElseOverride = EmailServiceDefault.actually(ccList, overrideCc))) {
                email.addCc(ccListElseOverride);
            }
            if (EmailServiceDefault.notEmpty(bccListElseOverride = EmailServiceDefault.actually(bccList, overrideBcc))) {
                email.addBcc(bccListElseOverride);
            }
            email.send();
        }
        catch (EmailException ex) {
            LOG.error("An error occurred while trying to send an email", (Throwable)ex);
            Boolean throwExceptionOnFail = this.isThrowExceptionOnFail();
            if (throwExceptionOnFail.booleanValue()) {
                throw new EmailServiceException(ex);
            }
            return false;
        }
        return true;
    }

    static String[] actually(List<String> original, String overrideIfAny) {
        List<String> addresses = Strings.isNullOrEmpty((String)overrideIfAny) ? (original == null ? Collections.emptyList() : original) : Collections.singletonList(overrideIfAny);
        return addresses.toArray(new String[addresses.size()]);
    }

    static boolean notEmpty(String[] addresses) {
        return addresses != null && addresses.length > 0;
    }

    public static class EmailServiceException
    extends RuntimeException {
        static final long serialVersionUID = 1L;

        public EmailServiceException(EmailException cause) {
            super((Throwable)cause);
        }
    }
}

