/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.command;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.background.ActionInvocationMemento;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.memento.MementoService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.services.command.CommandDtoServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.core.runtime.services.memento.MementoServiceDefault;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.schema.cmd.v1.ActionDto;
import org.apache.isis.schema.cmd.v1.CommandDto;
import org.apache.isis.schema.cmd.v1.MemberDto;
import org.apache.isis.schema.cmd.v1.ParamDto;
import org.apache.isis.schema.cmd.v1.ParamsDto;
import org.apache.isis.schema.cmd.v1.PropertyDto;
import org.apache.isis.schema.common.v1.InteractionType;
import org.apache.isis.schema.common.v1.OidsDto;
import org.apache.isis.schema.common.v1.ValueWithTypeDto;
import org.apache.isis.schema.utils.CommandDtoUtils;
import org.apache.isis.schema.utils.CommonDtoUtils;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class CommandDtoServiceInternalDefault
implements CommandDtoServiceInternal {
    private final MementoServiceDefault mementoService;
    @Inject
    CommandContext commandContext;
    @Inject
    private BookmarkService bookmarkService;
    @Inject
    SpecificationLoader specificationLoader;
    @Inject
    IsisSessionFactory isisSessionFactory;

    public CommandDtoServiceInternalDefault() {
        this(new MementoServiceDefault());
    }

    CommandDtoServiceInternalDefault(MementoServiceDefault mementoService) {
        this.mementoService = mementoService.withNoEncoding();
    }

    @Programmatic
    @PostConstruct
    public void init(Map<String, String> props) {
    }

    private ObjectSpecificationDefault getJavaSpecificationOfOwningClass(Method method) {
        return this.getJavaSpecification(method.getDeclaringClass());
    }

    private ObjectSpecificationDefault getJavaSpecification(Class<?> cls) {
        ObjectSpecification objectSpec = this.getSpecification(cls);
        if (!(objectSpec instanceof ObjectSpecificationDefault)) {
            throw new UnsupportedOperationException("Only Java is supported (specification is '" + objectSpec.getClass().getCanonicalName() + "')");
        }
        return (ObjectSpecificationDefault)objectSpec;
    }

    private ObjectSpecification getSpecification(Class<?> type) {
        return this.specificationLoader.loadSpecification(type);
    }

    @Deprecated
    @Programmatic
    public ActionInvocationMemento asActionInvocationMemento(Method method, Object domainObject, Object[] args) {
        ObjectSpecificationDefault targetObjSpec = this.getJavaSpecificationOfOwningClass(method);
        ObjectMember member = targetObjSpec.getMember(method);
        if (member == null) {
            return null;
        }
        if (!(member instanceof ObjectAction)) {
            throw new UnsupportedOperationException(String.format("Method %s does not correspond to an action.", method.getName()));
        }
        ObjectAction action = (ObjectAction)member;
        String actionIdentifier = CommandUtil.memberIdentifierFor((ObjectMember)action);
        Bookmark domainObjectBookmark = this.bookmarkService.bookmarkFor(domainObject);
        ArrayList argTypes = Lists.newArrayList();
        ArrayList argObjs = Lists.newArrayList();
        CommandUtil.buildMementoArgLists((MementoService)this.mementoService, (BookmarkService)this.bookmarkService, (Method)method, (Object[])args, (List)argTypes, (List)argObjs);
        ActionInvocationMemento aim = new ActionInvocationMemento((MementoService)this.mementoService, actionIdentifier, domainObjectBookmark, (List)argTypes, (List)argObjs);
        return aim;
    }

    public CommandDto asCommandDto(List<ObjectAdapter> targetAdapters, ObjectAction objectAction, ObjectAdapter[] argAdapters) {
        CommandDto dto = this.asCommandDto(targetAdapters);
        ActionDto actionDto = new ActionDto();
        actionDto.setInteractionType(InteractionType.ACTION_INVOCATION);
        dto.setMember((MemberDto)actionDto);
        this.addActionArgs(objectAction, actionDto, argAdapters);
        return dto;
    }

    public CommandDto asCommandDto(List<ObjectAdapter> targetAdapters, OneToOneAssociation property, ObjectAdapter valueAdapterOrNull) {
        CommandDto dto = this.asCommandDto(targetAdapters);
        PropertyDto propertyDto = new PropertyDto();
        propertyDto.setInteractionType(InteractionType.PROPERTY_EDIT);
        dto.setMember((MemberDto)propertyDto);
        this.addPropertyValue(property, propertyDto, valueAdapterOrNull);
        return dto;
    }

    private CommandDto asCommandDto(List<ObjectAdapter> targetAdapters) {
        CommandDto dto = new CommandDto();
        dto.setMajorVersion("1");
        dto.setMinorVersion("0");
        String transactionId = this.determineTransactionId().toString();
        dto.setTransactionId(transactionId);
        for (ObjectAdapter targetAdapter : targetAdapters) {
            RootOid rootOid = (RootOid)targetAdapter.getOid();
            Bookmark bookmark = rootOid.asBookmark();
            OidsDto targets = CommandDtoUtils.targetsFor((CommandDto)dto);
            targets.getOid().add(bookmark.toOidDto());
        }
        return dto;
    }

    protected UUID determineTransactionId() {
        Command command = this.commandContext.getCommand();
        if (command != null && command.getTransactionId() != null) {
            return command.getTransactionId();
        }
        return UUID.randomUUID();
    }

    public void addActionArgs(ObjectAction objectAction, ActionDto actionDto, ObjectAdapter[] argAdapters) {
        String actionId = CommandUtil.memberIdentifierFor((ObjectMember)objectAction);
        ObjectSpecification onType = objectAction.getOnType();
        String objectType = onType.getSpecId().asString();
        String localId = objectAction.getIdentifier().toNameIdentityString();
        actionDto.setLogicalMemberIdentifier(objectType + "#" + localId);
        actionDto.setMemberIdentifier(actionId);
        List actionParameters = objectAction.getParameters();
        for (int paramNum = 0; paramNum < actionParameters.size(); ++paramNum) {
            ObjectActionParameter actionParameter = (ObjectActionParameter)actionParameters.get(paramNum);
            String parameterName = actionParameter.getName();
            Class paramType = actionParameter.getSpecification().getCorrespondingClass();
            ObjectAdapter argAdapter = argAdapters[paramNum];
            Object arg = argAdapter != null ? argAdapter.getObject() : null;
            ParamsDto parameters = CommandDtoUtils.parametersFor((ActionDto)actionDto);
            List parameterList = parameters.getParameter();
            ParamDto paramDto = CommonDtoUtils.newParamDto((String)parameterName, (Class)paramType, (Object)arg, (BookmarkService)this.bookmarkService);
            parameterList.add(paramDto);
        }
    }

    public void addPropertyValue(OneToOneAssociation property, PropertyDto propertyDto, ObjectAdapter valueAdapter) {
        String actionIdentifier = CommandUtil.memberIdentifierFor((ObjectMember)property);
        ObjectSpecification onType = property.getOnType();
        String objectType = onType.getSpecId().asString();
        String localId = property.getIdentifier().toNameIdentityString();
        propertyDto.setLogicalMemberIdentifier(objectType + "#" + localId);
        propertyDto.setMemberIdentifier(actionIdentifier);
        ObjectSpecification valueSpec = property.getSpecification();
        Class valueType = valueSpec.getCorrespondingClass();
        ValueWithTypeDto newValue = CommonDtoUtils.newValueWithTypeDto((Class)valueType, (Object)ObjectAdapter.Util.unwrap((ObjectAdapter)valueAdapter), (BookmarkService)this.bookmarkService);
        propertyDto.setNewValue(newValue);
    }

    protected AdapterManager getAdapterManager() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }
}

