/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.background;

import javax.inject.Inject;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandExecutorService;
import org.apache.isis.applib.services.command.CommandWithDto;
import org.apache.isis.core.runtime.sessiontemplate.AbstractIsisSessionTemplate;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandExecutionAbstract
extends AbstractIsisSessionTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(CommandExecutionAbstract.class);
    private final CommandExecutorService.SudoPolicy sudoPolicy;
    @Inject
    CommandExecutorService commandExecutorService;

    protected CommandExecutionAbstract(CommandExecutorService.SudoPolicy sudoPolicy) {
        this.sudoPolicy = sudoPolicy;
    }

    protected final void execute(IsisTransactionManager transactionManager, CommandWithDto commandWithDto) {
        transactionManager.startTransaction((Command)commandWithDto);
        this.commandExecutorService.executeCommand(this.sudoPolicy, commandWithDto);
        transactionManager.endTransaction();
    }
}

