/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.background;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.background.ActionInvocationMemento;
import org.apache.isis.applib.services.background.BackgroundCommandService;
import org.apache.isis.applib.services.background.BackgroundCommandService2;
import org.apache.isis.applib.services.background.BackgroundService2;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.services.command.CommandDtoServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.JavassistEnhanced;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionMixedIn;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.schema.cmd.v1.CommandDto;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class BackgroundServiceDefault
implements BackgroundService2 {
    @Inject
    private BackgroundCommandService backgroundCommandService;
    @Inject
    private CommandDtoServiceInternal commandDtoServiceInternal;
    @Inject
    private CommandContext commandContext;
    @Inject
    private FactoryService factoryService;
    @Inject
    private SpecificationLoader specificationLoader;
    @Inject
    private IsisSessionFactory isisSessionFactory;

    @Programmatic
    @PostConstruct
    public void init(Map<String, String> props) {
    }

    @Programmatic
    @PreDestroy
    public void shutdown() {
    }

    private ObjectSpecificationDefault getJavaSpecificationOfOwningClass(Method method) {
        return this.getJavaSpecification(method.getDeclaringClass());
    }

    private ObjectSpecificationDefault getJavaSpecification(Class<?> cls) {
        ObjectSpecification objectSpec = this.getSpecification(cls);
        if (!(objectSpec instanceof ObjectSpecificationDefault)) {
            throw new UnsupportedOperationException("Only Java is supported (specification is '" + objectSpec.getClass().getCanonicalName() + "')");
        }
        return (ObjectSpecificationDefault)objectSpec;
    }

    private ObjectSpecification getSpecification(Class<?> type) {
        return this.specificationLoader.loadSpecification(type);
    }

    @Programmatic
    public <T> T execute(T domainObject) {
        Class<?> cls = domainObject.getClass();
        MethodHandler methodHandler = this.newMethodHandler(domainObject, null);
        return this.newProxy(cls, null, methodHandler);
    }

    public <T> T executeMixin(Class<T> mixinClass, Object mixedIn) {
        Object mixin = this.factoryService.mixin(mixinClass, mixedIn);
        MethodHandler methodHandler = this.newMethodHandler(mixin, mixedIn);
        return this.newProxy(mixinClass, mixedIn, methodHandler);
    }

    private <T> T newProxy(Class<? extends Object> cls, Object mixedInIfAny, MethodHandler methodHandler) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(cls);
        proxyFactory.setInterfaces((Class[])ArrayExtensions.combine((Object[][])new Class[][]{cls.getInterfaces(), {JavassistEnhanced.class}}));
        proxyFactory.setFilter(new MethodFilter(){

            public boolean isHandled(Method m) {
                return !m.getName().equals("finalize");
            }
        });
        Class proxySubclass = proxyFactory.createClass();
        try {
            Object newInstance;
            if (mixedInIfAny == null) {
                newInstance = proxySubclass.newInstance();
            } else {
                Constructor<?> constructor = this.findConstructor(proxySubclass, mixedInIfAny);
                newInstance = constructor.newInstance(mixedInIfAny);
            }
            ProxyObject proxyObject = (ProxyObject)newInstance;
            proxyObject.setHandler(methodHandler);
            return newInstance;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IsisException((Throwable)e);
        }
    }

    private <T> Constructor<?> findConstructor(Class<T> proxySubclass, Object mixedInIfAny) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = proxySubclass.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(mixedInIfAny.getClass())) continue;
            return constructor;
        }
        throw new IllegalArgumentException(String.format("Could not locate 1-arg constructor for mixin type of '%s' accepting an instance of '%s'", proxySubclass, mixedInIfAny.getClass().getName()));
    }

    private <T> MethodHandler newMethodHandler(final T target, final Object mixedInIfAny) {
        return new MethodHandler(){

            public Object invoke(Object proxied, Method proxyMethod, Method proxiedMethod, Object[] args) throws Throwable {
                Object domainObject;
                boolean inheritedFromObject = proxyMethod.getDeclaringClass().equals(Object.class);
                if (inheritedFromObject) {
                    return proxyMethod.invoke(target, args);
                }
                ObjectSpecificationDefault targetObjSpec = BackgroundServiceDefault.this.getJavaSpecificationOfOwningClass(proxyMethod);
                ObjectMember member = targetObjSpec.getMember(proxyMethod);
                if (member == null) {
                    return proxyMethod.invoke(target, args);
                }
                if (!(member instanceof ObjectAction)) {
                    throw new UnsupportedOperationException("Only actions can be executed in the background (method " + proxiedMethod.getName() + " represents a " + member.getFeatureType().name() + "')");
                }
                ObjectAction action = (ObjectAction)member;
                if (mixedInIfAny == null) {
                    domainObject = target;
                } else {
                    domainObject = mixedInIfAny;
                    action = this.findMixedInAction(action, mixedInIfAny);
                }
                ObjectAdapter domainObjectAdapter = BackgroundServiceDefault.this.getAdapterManager().adapterFor(domainObject);
                String domainObjectClassName = CommandUtil.targetClassNameFor((ObjectAdapter)domainObjectAdapter);
                String targetActionName = CommandUtil.targetMemberNameFor((ObjectMember)action);
                ObjectAdapter[] argAdapters = this.adaptersFor(args);
                String targetArgs = CommandUtil.argDescriptionFor((ObjectAction)action, (ObjectAdapter[])argAdapters);
                Command command = BackgroundServiceDefault.this.commandContext.getCommand();
                if (BackgroundServiceDefault.this.backgroundCommandService instanceof BackgroundCommandService2) {
                    BackgroundCommandService2 bcs2 = (BackgroundCommandService2)BackgroundServiceDefault.this.backgroundCommandService;
                    List<ObjectAdapter> targetList = Collections.singletonList(domainObjectAdapter);
                    CommandDto dto = BackgroundServiceDefault.this.commandDtoServiceInternal.asCommandDto(targetList, action, argAdapters);
                    bcs2.schedule(dto, command, domainObjectClassName, targetActionName, targetArgs);
                } else {
                    ActionInvocationMemento aim = BackgroundServiceDefault.this.commandDtoServiceInternal.asActionInvocationMemento(proxyMethod, target, args);
                    BackgroundServiceDefault.this.backgroundCommandService.schedule(aim, command, domainObjectClassName, targetActionName, targetArgs);
                }
                return null;
            }

            private ObjectAction findMixedInAction(ObjectAction action, Object domainObject) {
                String actionId = action.getId();
                ObjectSpecification domainSpec = BackgroundServiceDefault.this.getAdapterManager().adapterFor(domainObject).getSpecification();
                List objectActions = domainSpec.getObjectActions(Contributed.INCLUDED);
                for (ObjectAction objectAction : objectActions) {
                    ObjectActionMixedIn objectActionMixedIn;
                    if (!(objectAction instanceof ObjectActionMixedIn) || !(objectActionMixedIn = (ObjectActionMixedIn)objectAction).hasMixinAction(action)) continue;
                    return objectActionMixedIn;
                }
                throw new IllegalArgumentException(String.format("Unable to find mixin action '%s' for %s", actionId, domainSpec.getFullIdentifier()));
            }

            ObjectAdapter[] adaptersFor(Object[] args) {
                AdapterManager adapterManager = BackgroundServiceDefault.this.getAdapterManager();
                return CommandUtil.adaptersFor((Object[])args, (AdapterManager)adapterManager);
            }
        };
    }

    @Programmatic
    public ActionInvocationMemento asActionInvocationMemento(Method method, Object domainObject, Object[] args) {
        throw new RuntimeException("Replaced by InteractionDtoServiceInternal");
    }

    protected AdapterManager getAdapterManager() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }
}

