/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.auditing;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.audit.AuditerService;
import org.apache.isis.applib.services.audit.AuditingService3;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.iactn.InteractionContext;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.applib.services.xactn.Transaction;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.facets.object.audit.AuditableFacet;
import org.apache.isis.core.runtime.services.changes.AdapterAndProperty;
import org.apache.isis.core.runtime.services.changes.ChangedObjectsServiceInternal;
import org.apache.isis.core.runtime.services.changes.PreAndPostValues;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class AuditingServiceInternal {
    Boolean whetherCanAudit;
    @Inject
    private AuditingService3 auditingServiceIfAny;
    @Inject
    private List<AuditerService> auditerServices;
    @Inject
    private ChangedObjectsServiceInternal changedObjectsServiceInternal;
    @Inject
    UserService userService;
    @Inject
    ClockService clockService;
    @Inject
    InteractionContext interactionContext;
    @Inject
    TransactionService transactionService;

    private boolean canAudit() {
        if (this.whetherCanAudit == null) {
            this.whetherCanAudit = this.determineWhetherCanAudit();
        }
        return this.whetherCanAudit;
    }

    private boolean determineWhetherCanAudit() {
        if (this.auditingServiceIfAny != null) {
            return true;
        }
        for (AuditerService auditerService : this.auditerServices) {
            if (!auditerService.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Programmatic
    public void audit() {
        if (!this.canAudit()) {
            return;
        }
        Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> changedObjectProperties = this.changedObjectsServiceInternal.getChangedObjectProperties();
        String currentUser = this.userService.getUser().getName();
        Timestamp currentTime = this.clockService.nowAsJavaSqlTimestamp();
        for (Map.Entry<AdapterAndProperty, PreAndPostValues> auditEntry : changedObjectProperties) {
            this.auditChangedProperty(currentTime, currentUser, auditEntry);
        }
    }

    private void auditChangedProperty(Timestamp timestamp, String user, Map.Entry<AdapterAndProperty, PreAndPostValues> auditEntry) {
        AdapterAndProperty aap = auditEntry.getKey();
        ObjectAdapter adapter = aap.getAdapter();
        AuditableFacet auditableFacet = (AuditableFacet)adapter.getSpecification().getFacet(AuditableFacet.class);
        if (auditableFacet == null || auditableFacet.isDisabled()) {
            return;
        }
        Bookmark target = aap.getBookmark();
        String propertyId = aap.getPropertyId();
        String memberId = aap.getMemberId();
        PreAndPostValues papv = auditEntry.getValue();
        String preValue = papv.getPreString();
        String postValue = papv.getPostString();
        String targetClass = CommandUtil.targetClassNameFor((ObjectAdapter)adapter);
        Transaction transaction = this.transactionService.currentTransaction();
        UUID transactionId = transaction.getTransactionId();
        int sequence = transaction.getSequence();
        if (this.auditingServiceIfAny != null) {
            this.auditingServiceIfAny.audit(transactionId, targetClass, target, memberId, propertyId, preValue, postValue, user, timestamp);
        }
        for (AuditerService auditerService : this.auditerServices) {
            if (!auditerService.isEnabled()) continue;
            auditerService.audit(transactionId, sequence, targetClass, target, memberId, propertyId, preValue, postValue, user, timestamp);
        }
    }
}

