/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.runner.opts;

import com.google.common.collect.Maps;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.isis.core.commons.configbuilder.IsisConfigurationBuilder;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandlerAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionHandlerInitParameters
extends OptionHandlerAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(OptionHandlerInitParameters.class);
    private final ServletContext servletContext;

    public OptionHandlerInitParameters(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void addOption(Options options) {
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        return true;
    }

    public void prime(IsisConfigurationBuilder isisConfigurationBuilder) {
        Map<String, String> additionalProperties = OptionHandlerInitParameters.asMap(this.servletContext);
        LOG.debug("priming configuration builder: {} properties to prime", (Object)additionalProperties.size());
        OptionHandlerInitParameters.addConfigurationProperties(isisConfigurationBuilder, additionalProperties);
    }

    private static Map<String, String> asMap(ServletContext servletContext) {
        Enumeration initParameterNames = servletContext.getInitParameterNames();
        TreeMap map = Maps.newTreeMap();
        while (initParameterNames.hasMoreElements()) {
            String initParameterName = (String)initParameterNames.nextElement();
            String initParameterValue = servletContext.getInitParameter(initParameterName);
            if (!initParameterName.startsWith("isis.")) continue;
            map.put(initParameterName, initParameterValue);
        }
        return map;
    }

    private static void addConfigurationProperties(IsisConfigurationBuilder isisConfigurationBuilder, Map<String, String> additionalProperties) {
        for (String propertyKey : additionalProperties.keySet()) {
            String propertyValue = additionalProperties.get(propertyKey);
            LOG.debug("priming: {}={}", (Object)propertyKey, (Object)propertyValue);
            isisConfigurationBuilder.add(propertyKey, propertyValue);
        }
    }
}

