/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.query;

import java.io.IOException;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.encoding.Encodable;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;

public abstract class PersistenceQueryAbstract
implements PersistenceQuery,
Encodable {
    protected final long start;
    protected final long count;
    private final ObjectSpecification specification;
    private final SpecificationLoader specificationLoader;

    public PersistenceQueryAbstract(ObjectSpecification specification, SpecificationLoader specificationLoader, long ... range) {
        this.specificationLoader = specificationLoader;
        this.start = range.length > 0 ? range[0] : 0L;
        this.count = range.length > 1 ? range[1] : 0L;
        this.specification = specification;
    }

    protected PersistenceQueryAbstract(DataInputExtended input, SpecificationLoader specificationLoader, long ... range) throws IOException {
        this.specificationLoader = specificationLoader;
        String specName = input.readUTF();
        this.start = range.length > 0 ? range[0] : 0L;
        this.count = range.length > 1 ? range[1] : 0L;
        this.specification = specificationLoader.loadSpecification(specName);
    }

    public void encode(DataOutputExtended output) throws IOException {
        output.writeUTF(this.specification.getFullIdentifier());
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public ObjectSpecification getSpecification() {
        return this.specification;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistenceQueryAbstract other = (PersistenceQueryAbstract)obj;
        return !(this.specification == null ? other.specification != null : !this.specification.equals(other.specification));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 1231;
        result = 31 * result + (this.specification == null ? 0 : this.specification.hashCode());
        return result;
    }
}

