/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.adapter;

import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.ParentedCollectionOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.spec.ElementSpecificationProvider;
import org.apache.isis.core.metamodel.spec.Instance;
import org.apache.isis.core.metamodel.spec.InstanceAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.Specification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.datanucleus.enhancement.Persistable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoAdapter
extends InstanceAbstract
implements ObjectAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(PojoAdapter.class);
    private final AuthenticationSession authenticationSession;
    private final SpecificationLoader specificationLoader;
    private final PersistenceSession persistenceSession;
    private Object pojo;
    private Oid oid;
    private ElementSpecificationProvider elementSpecificationProvider;

    public PojoAdapter(Object pojo, Oid oid, AuthenticationSession authenticationSession, SpecificationLoader specificationLoader, PersistenceSession persistenceSession) {
        this.persistenceSession = persistenceSession;
        this.specificationLoader = specificationLoader;
        this.authenticationSession = authenticationSession;
        if (pojo instanceof ObjectAdapter) {
            throw new IsisException("Adapter can't be used to adapt an adapter: " + pojo);
        }
        this.pojo = pojo;
        this.oid = oid;
    }

    public ObjectSpecification getSpecification() {
        return (ObjectSpecification)super.getSpecification();
    }

    protected ObjectSpecification loadSpecification() {
        Class<?> aClass = this.getObject().getClass();
        ObjectSpecification specification = this.specificationLoader.loadSpecification(aClass);
        return specification;
    }

    public Object getObject() {
        return this.pojo;
    }

    public void replacePojo(Object pojo) {
        this.pojo = pojo;
    }

    public Oid getOid() {
        return this.oid;
    }

    public void replaceOid(Oid persistedOid) {
        Ensure.ensureThatArg((Object)this.oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.oid = persistedOid;
    }

    public boolean isParentedCollection() {
        return this.oid instanceof ParentedCollectionOid;
    }

    public boolean isValue() {
        return this.oid == null;
    }

    public boolean isTransient() {
        if (this.getSpecification().isService() || this.getSpecification().isViewModel()) {
            return false;
        }
        if (this.pojo instanceof Persistable) {
            Persistable pojo = (Persistable)this.pojo;
            boolean isPersistent = pojo.dnIsPersistent();
            boolean isDeleted = pojo.dnIsDeleted();
            if (!isPersistent && !isDeleted) {
                return true;
            }
        }
        return false;
    }

    public boolean representsPersistent() {
        if (this.getSpecification().isService() || this.getSpecification().isViewModel()) {
            return true;
        }
        if (this.pojo instanceof Persistable) {
            Persistable pojo = (Persistable)this.pojo;
            boolean isPersistent = pojo.dnIsPersistent();
            boolean isDeleted = pojo.dnIsDeleted();
            if (isPersistent) {
                return true;
            }
        }
        return false;
    }

    public boolean isDestroyed() {
        Persistable pojo;
        boolean isDeleted;
        if (this.getSpecification().isService() || this.getSpecification().isViewModel()) {
            return false;
        }
        return this.pojo instanceof Persistable && (isDeleted = (pojo = (Persistable)this.pojo).dnIsDeleted());
    }

    public ObjectAdapter getAggregateRoot() {
        if (!this.isParentedCollection()) {
            return this;
        }
        ParentedCollectionOid collectionOid = (ParentedCollectionOid)this.oid;
        return this.persistenceSession.getAggregateRoot(collectionOid);
    }

    public Version getVersion() {
        if (this.isParentedCollection()) {
            return this.getAggregateRoot().getVersion();
        }
        return this.getOid().getVersion();
    }

    public void checkLock(Version otherVersion) {
        if (this.isParentedCollection()) {
            this.getAggregateRoot().checkLock(otherVersion);
            return;
        }
        Oid thisOid = this.getOid();
        Version thisVersion = thisOid.getVersion();
        if (thisVersion != null && otherVersion != null && thisVersion.different(otherVersion)) {
            if (AdapterManager.ConcurrencyChecking.isCurrentlyEnabled()) {
                LOG.info("concurrency conflict detected on {} ({})", (Object)thisOid, (Object)otherVersion);
                String currentUser = this.authenticationSession.getUserName();
                throw new ConcurrencyException(currentUser, thisOid, thisVersion, otherVersion);
            }
            LOG.info("concurrency conflict detected but suppressed, on {} ({})", (Object)thisOid, (Object)otherVersion);
        }
    }

    public void setVersion(Version version) {
        if (this.isParentedCollection()) {
            return;
        }
        if (this.shouldSetVersion(version)) {
            RootOid rootOid = (RootOid)this.getOid();
            rootOid.setVersion(version);
        }
    }

    private boolean shouldSetVersion(Version otherVersion) {
        Version version = this.getOid().getVersion();
        return version == null || otherVersion == null || otherVersion.different(version);
    }

    public String titleString() {
        return this.titleString(null);
    }

    public String titleString(ObjectAdapter contextAdapterIfAny) {
        if (this.getSpecification().isParentedOrFreeCollection()) {
            CollectionFacet facet = (CollectionFacet)this.getSpecification().getFacet(CollectionFacet.class);
            return this.collectionTitleString(facet);
        }
        return this.objectTitleString(contextAdapterIfAny);
    }

    private String objectTitleString(ObjectAdapter contextAdapterIfAny) {
        if (this.getObject() instanceof String) {
            return (String)this.getObject();
        }
        ObjectSpecification specification = this.getSpecification();
        String title = specification.getTitle(contextAdapterIfAny, (ObjectAdapter)this);
        if (title == null) {
            title = this.getDefaultTitle();
        }
        return title;
    }

    private String collectionTitleString(CollectionFacet facet) {
        int size = facet.size((ObjectAdapter)this);
        ObjectSpecification elementSpecification = this.getElementSpecification();
        if (elementSpecification == null || elementSpecification.getFullIdentifier().equals(Object.class.getName())) {
            switch (size) {
                case -1: {
                    return "Objects";
                }
                case 0: {
                    return "No objects";
                }
                case 1: {
                    return "1 object";
                }
            }
            return size + " objects";
        }
        switch (size) {
            case -1: {
                return elementSpecification.getPluralName();
            }
            case 0: {
                return "No " + elementSpecification.getPluralName();
            }
            case 1: {
                return "1 " + elementSpecification.getSingularName();
            }
        }
        return size + " " + elementSpecification.getPluralName();
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        this.toString(str);
        str.append("pojo-toString", this.pojo.toString());
        str.appendAsHex("pojo-hash", (long)this.pojo.hashCode());
        return str.toString();
    }

    protected String getDefaultTitle() {
        return "A" + (" " + this.getSpecification().getSingularName()).toLowerCase();
    }

    protected void toString(ToString str) {
        str.append(this.aggregateResolveStateCode());
        Oid oid = this.getOid();
        if (oid != null) {
            str.append(":");
            str.append(oid.toString());
        } else {
            str.append(":-");
        }
        str.setAddComma();
        if (this.getSpecificationNoLoad() == null) {
            str.append("class", this.getObject().getClass().getName());
        } else {
            str.append("specification", this.getSpecification().getShortIdentifier());
        }
        if (this.getOid() != null) {
            Version version = this.getOid().getVersion();
            str.append("version", version != null ? version.sequence() : null);
        }
    }

    private String aggregateResolveStateCode() {
        Oid oid = this.getOid();
        if (oid != null) {
            if (oid.isPersistent()) {
                return "P";
            }
            if (oid.isTransient()) {
                return "T";
            }
            if (oid.isViewModel()) {
                return "V";
            }
        }
        return "S";
    }

    public String getIconName() {
        return this.getSpecification().getIconName((ObjectAdapter)this);
    }

    public ObjectSpecification getElementSpecification() {
        if (this.elementSpecificationProvider == null) {
            return null;
        }
        return this.elementSpecificationProvider.getElementType();
    }

    public void setElementSpecificationProvider(ElementSpecificationProvider elementSpecificationProvider) {
        this.elementSpecificationProvider = elementSpecificationProvider;
    }

    public Instance getInstance(Specification specification) {
        throw new UnsupportedOperationException();
    }
}

