/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.headless.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class LogStream
extends OutputStream {
    private final Logger logger;
    private final Level level;
    private final StringBuilder buf = new StringBuilder();

    public static PrintStream logPrintStream(Logger logger, Level level) {
        return new PrintStream(new LogStream(logger, level));
    }

    public LogStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
        String message = this.toString();
        switch (this.level) {
            case ERROR: {
                this.logger.error(message);
                break;
            }
            case WARN: {
                this.logger.warn(message);
                break;
            }
            case INFO: {
                this.logger.info(message);
                break;
            }
            case DEBUG: {
                this.logger.debug(message);
                break;
            }
            case TRACE: {
                this.logger.trace(message);
            }
        }
        this.buf.delete(0, this.buf.length());
    }

    @Override
    public void write(byte[] b) {
        String str = new String(b);
        this.buf.append(str);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        String str = new String(b, off, len);
        this.buf.append(str);
    }

    @Override
    public void write(int b) {
        String str = Integer.toString(b);
        this.buf.append(str);
    }

    public String toString() {
        return this.buf.toString();
    }
}

